// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
#ifndef CRTPATCH_HPP
#define CRTPATCH_HPP

#include "ptchfile.hpp"

#define COPYRIGHT "Patcher V1.0 (c) 1997/1998 by Olaf Panz, www.t-online.de/home/olaf.panz"
#define PATH_SEPARATOR '\\'

// ***************************************************************************
// 	Structure for Settings and statistics
// ***************************************************************************
struct TStatistics
{
	int iDirs;
   int iLookedFiles;
   int iAddedFiles;
   int iRemovedFiles;
   int iChangedTextFiles;
   int iChangedBinFiles;
};

struct TPreferences
{
	bool blRecursive;

	bool blDoBinDiff;   // create differences for bins
   bool blDoTextDiff;  // create differences for texts
   bool blDoTextBinDiff;  // create text and bin diff for text,
								  // get shortest
};


// ***************************************************************************
// main function to create the patch-file
// ***************************************************************************
bool create_patch (
			const char* cszNewPath,
         const char* cszOldPath,
         const char* cszPatchFile,
         const char* cszPatchName,
         const char* cszPatchDate,
         TStatistics& oStat,
         const TPreferences& oPrev);


// patch directory:
bool create_patch_directory (
	WritePatchFile& oFile,
	const char* cszNewPath,
   const char* szOldPath,
   const char* cszRelPath,
	char* szLastRelWorkPath, // last path where we had changes
   TStatistics& oStat,
   const TPreferences& oPrev);

// write naviagation blocks to file,
// only if necessary
bool write_navigate_path (
	WritePatchFile& oFile,
	const char* cszNewWorkPath,
   char* szOldWorkPath);

// Create patch for one file:
bool create_patch_file (	WritePatchFile& oFile,
									const char* cszNewFile,
                           const char* cszOldFile,
                           const char* cszRelPath,
                           char *szLastRelWorkPath,
                           const char* cszFilename,
                           unsigned int iNewFileSize,
                           unsigned int iOldFileSize,
									TStatistics& oStat,
						         const TPreferences& oPrev
  );


// write binary differences here
bool write_bin_diff (	WritePatchFile& oFile,
								const char *pNewBuffer,
                        unsigned int uiNewSize,
                        const char *pOldBuffer,
                        unsigned intuiOldSize,
                        const char *cszFilename,
                        TStatistics& oStat,
					         const TPreferences& oPrev);

// write text differences here
bool write_text_diff (	WritePatchFile& oFile,
								const char *pNewBuffer,
                        unsigned int uiNewSize,
                        const char *pOldBuffer,
                        unsigned intuiOldSize,
                        const char *cszFilename,
                        TStatistics& oStat,
					         const TPreferences& oPrev);


#endif //#ifndef CRTPATCH_HPP

