// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  File-Buffer
// ***************************************************************************
#include "fbuffer.hpp"
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <mem.h>
#include <stdlib.h>

// constructor load the file
TFileBuffer::TFileBuffer (const char *pFilename)
{
	m_pBuffer = 0;
   m_uiSize = 0;

   if (!pFilename)
   	return;

	FILE *pFile = fopen (pFilename,"rb");

   if (!pFile)
   	return;

   m_uiSize = filelength (fileno(pFile));

   m_pBuffer = (char*) malloc (m_uiSize+1);

   if (!m_pBuffer)
   {
   	fclose (pFile);
      m_uiSize = 0;
      return;
   }

   unsigned int uiRead= fread (m_pBuffer,1,m_uiSize,pFile);

   fclose (pFile);
   if (uiRead != m_uiSize)
   {
      free (m_pBuffer);
      m_pBuffer = 0;
      m_uiSize = 0;
   }
}

// Create buffer of uiSize Bytes
TFileBuffer::TFileBuffer (unsigned int uiSize)
{
	m_pBuffer = 0;
	m_uiSize = uiSize;
  	m_pBuffer = (char*) malloc (uiSize+1);
}

TFileBuffer::TFileBuffer (void)
{
	m_pBuffer = 0;
   m_uiSize = 0;
}


TFileBuffer::~TFileBuffer ()
{
	if (m_pBuffer)
   {
   	free (m_pBuffer);
	   m_pBuffer = 0;
   }
}


bool TFileBuffer::save (const char *pFilename,
				      		struct ftime* pFileTime,
				      		const char *pBuffer,
            				unsigned int uiSize) const
{
	if (!pFilename)
   	return false;

   if (pBuffer == 0)
   {
   	pBuffer = m_pBuffer;
      uiSize = m_uiSize;
   }

	FILE *pFile = fopen (pFilename,"wb");

   if (!pFile)
   	return false;

	unsigned int uiWrite = fwrite (pBuffer,1,uiSize,pFile);

   // set filetime
   if (pFileTime)
		setftime (fileno (pFile),pFileTime);

   fclose (pFile);

   return uiWrite == uiSize;
}
