// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  File-Buffer
// ***************************************************************************
#ifndef FBUFFER_HPP
#define FBUFFER_HPP

#include <sys\timeb.h>

#ifdef PTCHFILE_EXPORT
#undef PTCHFILE_EXPORT
#endif

#ifdef __PTCHBASEDLL__
#define PTCHFILE_EXPORT _export
#else
#define PTCHFILE_EXPORT _import
#endif

class PTCHFILE_EXPORT TFileBuffer
{
	private :

   	char* m_pBuffer;
      unsigned int m_uiSize;

   protected :

   public :

   	// constructor load the file
   	TFileBuffer (const char *pFilename);

      // Create buffer of uiSize Bytes
      TFileBuffer (unsigned int uiSize);

      // Create object without buffer
      TFileBuffer (void);

		virtual ~TFileBuffer ();

      unsigned int size (void) const { return m_uiSize; }
      char* buffer (void) const { return m_pBuffer; }

      bool save (	const char *pFilename,
   		   		struct ftime* pFileTime = 0,
	      			const char *pBuffer = 0,
            		unsigned int uiSize = 0) const;

      bool valid (void) const { return m_pBuffer != 0; }

};


#endif //FBUFFER_HPP
