// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
#include "crtpatch.hpp"
#include "ptchfile.hpp"
#include "block.hpp"

#include <dir.h>
#include <string.h>
#include <time.h>

bool do_patch (const char *pPatchFile,const char *pPath);

int main(int argc, char * argv[], char * /*env*/[])
{
	// print copyright first!
	printf (COPYRIGHT "\n");

   char szPath [MAXPATH];
   char szPatch [MAXPATH];

   // default values:
   szPath[0] = '\0';
   szPatch[0] = '\0';

 	// Help- and Error- Flags
   bool blPrintHelp = false;
   bool blAutoPrintHelp = true;
   bool blError = false;

	// extract parameters:
	int i;

   for (i=1;i<argc;i++)
   {
      if (argv[i][0] == '-' || argv[i][0] == '/')
      {
      	switch (argv[i][1])
         {
         	case 'p' :	//Old Path
            case 'P' :
            	strcpy (szPath,argv[i]+2);
               blAutoPrintHelp = false;
               break;
            case 'f' :  // new Path
            case 'F' :
            	strcpy (szPatch,argv[i]+2);
               if (strchr (szPatch,'.') == 0)
	               strcat (szPatch,".pth");

               blAutoPrintHelp = false;
               break;
            case 'h' : 	// print help
            case 'H' :
            case '?' :
            	blPrintHelp = true;
               break;
            default :
            	printf ("Unknown parameter : %s\n",argv[i]+1);
               break;
         }
      }
      else
   	{
      	printf ("Unknown character at the beginning of an argument: %c\n",
         			argv[i][0]);
      }
   }

	if (!szPatch [0])
   {
   	printf ("You must specify a patch-file\n");
		blError = true;
   }

   if (szPath[0])
   {
   	// add ending slash:
   	int i = strlen (szPath);

      if (szPath[i-1] != PATH_SEPARATOR)
      {
      	szPath[i] = PATH_SEPARATOR;
         szPath[i+1] = '\0';
      }
   }

   if (blPrintHelp == true || blAutoPrintHelp == true)
   {
   	printf ("Patcher patches a software with a patch file.\n");
      printf ("Call: patcher -f<Patchfile> -p<Path>\n");
   }

   if (blError == false)
   {
   	return do_patch (szPatch,szPath);
   }

   return 1;
}

bool do_patch (const char *cszPatchFile,const char *cszPath)
{
   // open patchfile
   ReadPatchFile oFile(cszPatchFile);

   if (oFile.valid () == false)
   {
   	printf ("Cant open patch file %s\n",cszPatchFile);
      return false;
   }

   PatchBlock *pBlock= oFile.next_block ();
   char szPath [MAXPATH];
   strcpy (szPath,cszPath);

   while (pBlock)
   {
   	pBlock -> proceed (szPath);
		delete pBlock;
      
   	pBlock = oFile.next_block ();
   }

   return true;
}

