// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  Patch-File- Handling
// ***************************************************************************
#include "ptchfile.hpp"
#include "block.hpp"

#include <mem.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <sys\stat.h>
#include <io.h>
#include <dos.h>
#include <conio.h>

#include "crtpatch.hpp"

// ***************************************************************************
//  Class : PatchFile
// ***************************************************************************
PatchFile::PatchFile (void)
{
	m_oFile = 0;
}

PatchFile::~PatchFile ()
{
	if (m_oFile)
   {
   	fclose (m_oFile);
      m_oFile = 0;
   }
}

// ***************************************************************************
//  Class : WritePatchFile
// ***************************************************************************
WritePatchFile::WritePatchFile (const char *cszFilename)
	: PatchFile ()
{
	if (cszFilename)
   {
   	m_oFile = fopen (cszFilename,"wb");

      if (!m_oFile)
      {
      	printf ("Cant open %s for writing.\n",cszFilename);
         return;
      }

      // Create Block 0: Copyright
      write_block (CopyrightPatchBlock ());
   }

}

// for later compression
/*bool WritePatchFile::write_byte (char byte)
{
	if (m_oFile)
   {
		fputc (byte,m_oFile);
      return true;
   }

   return false;
} */

bool WritePatchFile::write (const char *cszBuffer,unsigned int uiBufferSize)
{
	return fwrite (cszBuffer,1,uiBufferSize,m_oFile) == uiBufferSize;
/*	bool blRet = true;

	if (m_oFile)
   {
   	unsigned int i;
   	for (i=0;i<uiBufferSize;i++)
      {
      	if (write_byte (cszBuffer[i]) == false)
         	blRet = false;
      }
   }
   return blRet;*/
}

bool WritePatchFile::valid (void) const
{
	return m_oFile != NULL && feof (m_oFile) == 0;
}

void WritePatchFile::write_block (const PatchBlock& pBlock)
{
	unsigned int uiBlockType = pBlock.type ();
   // first: write type
   write ((char*)&uiBlockType,sizeof (uiBlockType));

   // write len second
   write ((char*)&(pBlock.m_uiLen),sizeof (pBlock.m_uiLen));

   // and write bypes
   write (pBlock.m_szBuffer,pBlock.m_uiLen);
}

// ***************************************************************************
//  ReadPatchFile
// ***************************************************************************

ReadPatchFile::ReadPatchFile (const char *cszFilename)
	: PatchFile ()
{
	if (cszFilename)
   {
   	m_oFile = fopen (cszFilename,"rb");
   }
}

// is this object valid?
bool ReadPatchFile::valid (void) const
{
	return m_oFile != NULL && feof (m_oFile) == 0;
}

bool ReadPatchFile::read (char *szBuffer,unsigned int uiBufferSize)
{
	return fread (szBuffer,1,uiBufferSize,m_oFile) == uiBufferSize;
}


// read the next block
// the caller must delete this block!!!!!
PatchBlock* ReadPatchFile::next_block (void)
{
   if (!valid())
   	return false;

	unsigned int uiBlockType,uiBlockLen;

   if (read ((char*)&uiBlockType,sizeof (uiBlockType)) == false)
   	return NULL;
   if (read ((char*)&uiBlockLen,sizeof (uiBlockLen)) == false)
   	return NULL;

   // create buffer for block:
   char *pBuffer = (char*) malloc (uiBlockLen+1);
   assert (pBuffer);

   if (read (pBuffer,uiBlockLen) == false)
   {
   	free (pBuffer);
      return NULL;
   }

   // create block object:
   PatchBlock *pErg = NULL;

   switch (uiBlockType)
   {
		case FILE_BLOCK_COPYRIGHT :
      	pErg = new CopyrightPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
		case FILE_BLOCK_INFO :
      	pErg = new InfoPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
		case FILE_BLOCK_PATH	:
      	pErg = new PathPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
		case FILE_BLOCK_DEL :
      	pErg = new RemovePatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
		case FILE_BLOCK_ADD_FILE :
      	pErg = new AddFilePatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
		case FILE_BLOCK_ADD_PATH :
      	pErg = new AddPathPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
   	case FILE_BLOCK_CHANGE_BIN	:
      	pErg = new ChangeBinPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
      case FILE_BLOCK_CHANGE_STORE :
      	pErg = new ChangeStorePatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;
/*		case FILE_BLOCK_CHANGE_TEXT :
      	pErg = new ChangeTextPatchBlock (pBuffer,uiBlockLen);
         assert (pErg);
         break;              */
   	default :
      	printf ("Read unknown block identifier %X File corrupted!\n",
         	uiBlockType);
         free (pBuffer);
         break;
   }

	return pErg;
}

