// ***************************************************************************
//		Patcher/CreatePatch
// ***************************************************************************
//  (c) 1997 by Olaf Panz
//  Niedere Strae 21
//  78050 VS-Villingen
//  www.t-online.de/home/olaf.panz
//  olaf.panz@gft.de
// ***************************************************************************
//	  Patch-File- Handling
// ***************************************************************************
#ifndef PTCHFILE_HPP
#define PTCHFILE_HPP

#include <assert.h>
#include <stdio.h>
#include <sys\timeb.h>

#ifdef PTCHFILE_EXPORT
#undef PTCHFILE_EXPORT
#endif

#ifdef __PTCHBASEDLL__
#define PTCHFILE_EXPORT _export
#else
#define PTCHFILE_EXPORT _import
#endif

// ***************************************************************************
// Patch-File Handling:
// ***************************************************************************
// Fileformat:
// <Block1><Block2>...<Blockn>
// Block:
// 	<BlockType>   1 Byte
//		<BlockLen>	  4 Byte (excluding Type and len)
// A Block can contain subblocks:
//  <BlockType><BlockLen><Subblock1>..<SubBlockn>
// ***************************************************************************

class PTCHFILE_EXPORT PatchBlock;

// ***************************************************************************
//  Class : PatchFile
// ***************************************************************************
// abstract base for Patch files:
class PTCHFILE_EXPORT PatchFile
{
	private :

   protected :

   	FILE *m_oFile;

   public :
   	virtual ~PatchFile (void);
      PatchFile (void);

   	virtual bool valid (void) const =0;
};

// ***************************************************************************
//  Class : WritePatchFile
// ***************************************************************************
class PTCHFILE_EXPORT WritePatchFile : public PatchFile
{
	private :

   protected :

		// for later compression
//   	bool write_byte (char byte);
      bool write (const char *cszBuffer,unsigned int uiBufferSize);

   public :

   	WritePatchFile (const char *cszFilename);
      virtual bool valid (void) const;
      void write_block (const PatchBlock& pBlock);
};

// ***************************************************************************
//  ReadPatchFile
// ***************************************************************************
class PTCHFILE_EXPORT ReadPatchFile : public PatchFile
{
	private :

   protected :

      bool read (char *szBuffer,unsigned int uiBufferSize);

   public :

   	ReadPatchFile (const char *cszFilename);

      // is this object valid?
      virtual bool valid (void) const;

      // read the next block
      // the caller must delete this block!!!!!
      PatchBlock* next_block (void);

};

#endif //#ifndef PTCHFILE_HPP

