/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.ASCIIFilterWriter;
import de.olafpanz.translationtable.LocaleDef;
import de.olafpanz.translationtable.TranslationDataType;
import de.olafpanz.translationtable.TranslationDocument;
import de.olafpanz.translationtable.TranslationEntry;
import de.olafpanz.translationtable.TranslationTableParameters;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

final class CodeGenerator {
    private static final String ENCODING = "US-ASCII";
    private final TranslationDocument doc;
    private final TranslationTableParameters param;
    private final Set<TranslationDataType> usedTypes = EnumSet.noneOf(TranslationDataType.class);
    private static final Comparator<TranslationEntry> SORT_BY_TYPE_COMPARATOR = new Comparator<TranslationEntry>(){

        @Override
        public int compare(TranslationEntry translationEntry, TranslationEntry translationEntry2) {
            int n = translationEntry.getType().compareTo(translationEntry2.getType());
            if (n == 0 && (n = translationEntry.getGroup().compareTo(translationEntry2.getGroup())) == 0) {
                n = translationEntry.getKey().compareTo(translationEntry2.getKey());
            }
            return n;
        }
    };

    public CodeGenerator(TranslationDocument translationDocument, TranslationTableParameters translationTableParameters) {
        this.doc = translationDocument;
        this.param = translationTableParameters;
    }

    public void createFiles() throws IOException {
        String string;
        File file;
        Set<TranslationEntry> set = this.doc.getTranslations();
        if (set.isEmpty()) {
            return;
        }
        boolean bl = this.doc.hasRCP();
        boolean bl2 = this.doc.hasBundle();
        if (bl2) {
            file = new File(this.param.getSourceRoot(), this.doc.getPackageName().replace('.', File.separatorChar));
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Path creation failed: '" + file + "'.");
            }
            switch (this.param.getJdk()) {
                case JDK14: {
                    string = this.createKeyInterface(file);
                    break;
                }
                default: {
                    string = this.createEnumInterface(file);
                    break;
                }
            }
        } else {
            string = null;
            file = null;
        }
        this.createPluginProperties(-1);
        for (int i = 0; i < this.doc.getLocales().size(); ++i) {
            if (bl2) {
                this.createResourceFile(file, i, string);
            }
            if (!bl) continue;
            this.createPluginProperties(i);
        }
        if (bl2) {
            this.createManager(file, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createManager(File file, String string) throws IOException {
        PrintWriter printWriter = null;
        String string2 = this.doc.getClassName() + "TranslationManager";
        try {
            File file2 = new File(file, string2 + ".java");
            printWriter = new PrintWriter(new BufferedWriter(new ASCIIFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), ENCODING))));
            printWriter.println("package " + this.doc.getPackageName() + ";");
            printWriter.println();
            printWriter.println("import javax.swing.KeyStroke;");
            printWriter.println("import java.util.Locale;");
            printWriter.println("import java.util.ResourceBundle;");
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println("import java.util.Map;");
                    printWriter.println("import java.util.HashMap;");
                    break;
                }
            }
            printWriter.println();
            printWriter.println("/**");
            printWriter.println(" * " + this.doc.getClassComment());
            printWriter.println(" * This manager manages access to translation table.");
            printWriter.println(" */");
            printWriter.println("public final class " + string2);
            printWriter.println("{");
            printWriter.println();
            this.createMapLocaleMethod(printWriter);
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println("\t/**");
                    printWriter.println("\t * Maps from locale to translation table");
                    printWriter.println("\t */");
                    printWriter.println("\tprivate final static Map<Locale,ResourceBundle> bundleMap = new HashMap<Locale,ResourceBundle>();");
                    break;
                }
                case Client: {
                    printWriter.println("\t/**");
                    printWriter.println("\t * The translation table");
                    printWriter.println("\t */");
                    printWriter.println("\t private static ResourceBundle bundle;");
                    printWriter.println();
                    printWriter.println("\t/**");
                    printWriter.println("\t * Last returned locale.");
                    printWriter.println("\t */");
                    printWriter.println("\t private static Locale currentLocale;");
                }
            }
            printWriter.println();
            printWriter.println("\t/**");
            printWriter.println("\t * Clean all cached resources.");
            printWriter.println("\t */");
            printWriter.println("\tpublic static final void clean (){");
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println("\t\tsynchronized (" + string2 + ".class){");
                    printWriter.println("\t\t\tbundleMap.clear();");
                    printWriter.print("\t\t\t");
                    break;
                }
                case Client: {
                    printWriter.println("\t\tbundle = null;");
                    printWriter.print("\t\t");
                }
            }
            printWriter.println("ResourceBundle.clearCache ();");
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println("\t\t}");
                    break;
                }
            }
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\t/**");
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println("\t * @param locale Locale of requested bundle.");
                    break;
                }
            }
            printWriter.println("\t * @return bundle for default locale.");
            printWriter.println("\t */");
            printWriter.print("\tprivate static final ");
            switch (this.param.getEnvironment()) {
                case Server: {
                    printWriter.println(" ResourceBundle getBundle (final Locale locale) {");
                    printWriter.println("\t\tResourceBundle bundle = null;");
                    printWriter.println("\t\tsynchronized (" + string2 + ".class){");
                    printWriter.println("\t\t\tbundle = bundleMap.get (locale);");
                    printWriter.println("\t\t\tif (bundle == null){");
                    printWriter.println("\t\t\t\tbundle = ResourceBundle.getBundle (\"" + this.doc.getPackageName() + "." + this.doc.getClassName() + "\",mapLocale(locale));");
                    printWriter.println("\t\t\t\tbundleMap.put (locale,bundle);");
                    printWriter.println("\t\t\t}");
                    printWriter.println("\t\t}");
                    break;
                }
                case Client: {
                    printWriter.println(" ResourceBundle getBundle () {");
                    printWriter.println("\t\tif (bundle==null || !Locale.getDefault().equals (currentLocale)){");
                    printWriter.println("\t\t\tbundle = ResourceBundle.getBundle (\"" + this.doc.getPackageName() + "." + this.doc.getClassName() + "\",mapLocale(Locale.getDefault()));");
                    printWriter.println("\t\t}");
                }
            }
            printWriter.println("\t\treturn bundle;");
            printWriter.println("\t}");
            switch (this.param.getJdk()) {
                case JDK14: {
                    if (this.usedTypes.contains((Object)TranslationDataType.Text)) {
                        this.create14AccessMethod(printWriter, "Text", "String");
                    }
                    if (this.usedTypes.contains((Object)TranslationDataType.Tooltip)) {
                        this.create14AccessMethod(printWriter, "Tooltip", "String");
                    }
                    if (this.usedTypes.contains((Object)TranslationDataType.Accelerator)) {
                        this.create14AccessMethod(printWriter, "Accelerator", "KeyStroke");
                    }
                    if (!this.usedTypes.contains((Object)TranslationDataType.Mnemonic)) break;
                    this.create14AccessMethod(printWriter, "Mnemonic", "Character");
                    break;
                }
                default: {
                    if (this.usedTypes.contains((Object)TranslationDataType.Text)) {
                        this.create15AccessMethod(printWriter, TranslationDataType.Text, "String", string);
                    }
                    if (this.usedTypes.contains((Object)TranslationDataType.Tooltip)) {
                        this.create15AccessMethod(printWriter, TranslationDataType.Tooltip, "String", string);
                    }
                    if (this.usedTypes.contains((Object)TranslationDataType.Mnemonic)) {
                        this.create15AccessMethod(printWriter, TranslationDataType.Mnemonic, "Character", string);
                    }
                    if (!this.usedTypes.contains((Object)TranslationDataType.Accelerator)) break;
                    this.create15AccessMethod(printWriter, TranslationDataType.Accelerator, "KeyStroke", string);
                }
            }
            printWriter.println();
            printWriter.println("}");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private final void createMapLocaleMethod(PrintWriter printWriter) {
        ArrayList<LocaleDef> arrayList = new ArrayList<LocaleDef>(this.doc.getLocales());
        Collections.sort(arrayList);
        printWriter.println("\t/**");
        printWriter.println("\t * Array of Supported Locales. ");
        printWriter.println("\t */");
        printWriter.println("\tpublic static final Locale []SUPPORTED_LOCALES = new Locale[]{");
        for (LocaleDef localeDef : arrayList) {
            Locale locale = localeDef.getLocale();
            printWriter.print("\t\tnew Locale (\"" + locale.getLanguage() + "\"");
            String string = locale.getCountry();
            if (string != null && !string.isEmpty()) {
                printWriter.print(",\"" + string + "\"");
            }
            if ((string = locale.getVariant()) != null && !string.isEmpty()) {
                printWriter.print(",\"" + string + "\"");
            }
            printWriter.println("),");
        }
        printWriter.println("\t};");
        printWriter.println();
        printWriter.println("\t/**");
        printWriter.println("\t * Maps from any locale to locale existing in translation table.");
        printWriter.println("\t @return Is never null.");
        printWriter.println("\t @param locale Null is not allowed here");
        printWriter.println("\t */");
        printWriter.println("\tpublic static final Locale mapLocale (final Locale locale){");
        printWriter.println("\t\t// (1) check for exact match");
        printWriter.println("\t\tfor (Locale loc : SUPPORTED_LOCALES) {");
        printWriter.println("\t\t\tif (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) && loc.getVariant().equals (locale.getVariant())){");
        printWriter.println("\t\t\t\treturn loc;");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t}");
        printWriter.println("\t\t// (2) check for matching language and country");
        printWriter.println("\t\tfor (Locale loc : SUPPORTED_LOCALES) {");
        printWriter.println("\t\t\tif (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) ){");
        printWriter.println("\t\t\t\treturn loc;");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t}");
        printWriter.println("\t\t// (3) check for matching language only");
        printWriter.println("\t\tfor (Locale loc : SUPPORTED_LOCALES) {");
        printWriter.println("\t\t\tif (loc.getLanguage().equals (locale.getLanguage())){");
        printWriter.println("\t\t\t\treturn loc;");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t}");
        printWriter.println("\t\t// (4) Use default language");
        printWriter.println("\t\treturn SUPPORTED_LOCALES[" + this.doc.getDefaultLocale() + "];");
        printWriter.println("\t}");
    }

    private void create15AccessMethod(PrintWriter printWriter, TranslationDataType translationDataType, String string, String string2) {
        printWriter.println();
        printWriter.println("\t/**");
        printWriter.println("\t * Return " + (Object)((Object)translationDataType) + " object.");
        printWriter.println("\t * @param key The key to requested resource. Null is not allowed.");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.println("\t * @param locale Locale in that the resource is requested.");
                break;
            }
        }
        printWriter.println("\t * @return Is never null.");
        printWriter.println("\t */");
        printWriter.print("\tpublic static final ");
        printWriter.print(string + " get (final " + string2 + "." + translationDataType.getPrefix() + " key");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.print(",final Locale locale");
                break;
            }
        }
        printWriter.println(") {");
        printWriter.print("\t\treturn (" + string + ")getBundle (");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.print("locale");
                break;
            }
        }
        printWriter.println(").getObject (key.toString());");
        printWriter.println("\t}");
    }

    private void create14AccessMethod(PrintWriter printWriter, String string, String string2) {
        printWriter.println();
        printWriter.println("\t/**");
        printWriter.println("\t * Return " + string + " object.");
        printWriter.println("\t * @param key The key to requested resource. Null is not allowed.");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.println("\t * @param locale Locale in that the resource is requested.");
                break;
            }
        }
        printWriter.println("\t * @return Might be null, if key does not exist.");
        printWriter.println("\t */");
        printWriter.print("\tpublic static final ");
        printWriter.print(string2 + " get" + string + " (final String key");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.print(",final Locale locale");
                break;
            }
        }
        printWriter.println(") {");
        printWriter.print("\t\treturn (" + string2 + ")getBundle (");
        switch (this.param.getEnvironment()) {
            case Server: {
                printWriter.print("locale");
                break;
            }
        }
        printWriter.println(").getObject (key);");
        printWriter.println("\t}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createKeyInterface(File file) throws IOException {
        Set<TranslationEntry> set = this.doc.getTranslations();
        PrintWriter printWriter = null;
        String string = this.doc.getClassName() + "Keys";
        try {
            File file2 = new File(file, string + ".java");
            printWriter = new PrintWriter(new BufferedWriter(new ASCIIFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), ENCODING))));
            printWriter.println("package " + this.doc.getPackageName() + ";");
            printWriter.println();
            printWriter.println("/**");
            printWriter.println(" * " + this.doc.getClassComment());
            printWriter.println(" * This interface defines all keys to translations.");
            printWriter.print(" * Supported doc.getLocales(): ");
            boolean bl = true;
            for (LocaleDef object : this.doc.getLocales()) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(", ");
                }
                printWriter.print(object.getLocale().getDisplayName());
            }
            printWriter.println();
            printWriter.println(" */");
            switch (this.param.getJdk()) {
                case JDK14: {
                    printWriter.println("public interface " + string);
                    break;
                }
                case JDK15: {
                    printWriter.println("public enum " + string);
                }
            }
            printWriter.println("{");
            Object object = null;
            for (TranslationEntry translationEntry : set) {
                if (!translationEntry.getType().isInResourceBundle()) continue;
                this.usedTypes.add(translationEntry.getType());
                String string2 = translationEntry.getGroup();
                if (string2 != null && !string2.equals(object)) {
                    object = string2;
                    printWriter.println();
                    printWriter.println("\t//***************************************************************");
                    printWriter.println("\t//\tGroup: " + (String)object);
                    printWriter.println("\t//***************************************************************");
                }
                printWriter.println();
                printWriter.println("\t/** " + translationEntry.getJavaDoc(this.doc.getLocales(), "\t *  ", this.doc));
                printWriter.println("\t */");
                switch (this.param.getJdk()) {
                    case JDK14: {
                        printWriter.println("\tString " + translationEntry.getKey() + " = \"" + translationEntry.getKey() + "\";");
                        break;
                    }
                    case JDK15: {
                        printWriter.println("\t" + translationEntry.getKey() + ",");
                    }
                }
            }
            printWriter.println("}");
            printWriter.println();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createEnumInterface(File file) throws IOException {
        PrintWriter printWriter = null;
        Set<TranslationEntry> set = this.doc.getTranslations();
        String string = this.doc.getClassName() + "Keys";
        try {
            File file2 = new File(file, string + ".java");
            printWriter = new PrintWriter(new BufferedWriter(new ASCIIFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), ENCODING))));
            printWriter.println("package " + this.doc.getPackageName() + ";");
            printWriter.println();
            printWriter.println("/**");
            printWriter.println(" * " + this.doc.getClassComment());
            printWriter.println(" * This interface defines all keys to translations.");
            printWriter.print(" * Supported doc.getLocales(): ");
            boolean bl = true;
            for (LocaleDef object2 : this.doc.getLocales()) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(", ");
                }
                printWriter.print(object2.getLocale().getDisplayName());
            }
            printWriter.println();
            printWriter.println(" */");
            printWriter.println("public interface " + string);
            printWriter.println("{");
            Object object3 = null;
            ArrayList<TranslationEntry> arrayList = new ArrayList<TranslationEntry>(set);
            Collections.sort(arrayList, SORT_BY_TYPE_COMPARATOR);
            Enum enum_ = null;
            for (TranslationEntry translationEntry : arrayList) {
                String string2;
                boolean bl2;
                if (!translationEntry.getType().isInResourceBundle()) continue;
                this.usedTypes.add(translationEntry.getType());
                boolean bl3 = bl2 = enum_ == null;
                if (enum_ == null || !enum_.equals((Object)translationEntry.getType())) {
                    if (enum_ != null) {
                        this.createEmumMethods(printWriter, (TranslationDataType)enum_);
                        bl2 = true;
                        printWriter.println("\t}\n");
                    }
                    enum_ = translationEntry.getType();
                    if (!bl2) {
                        printWriter.println(",");
                        bl2 = true;
                    }
                    printWriter.println("\t/** Enumeration for " + enum_ + " */");
                    printWriter.println("\tpublic enum " + ((TranslationDataType)enum_).getPrefix() + " {");
                    object3 = null;
                }
                if (!bl2) {
                    printWriter.println(",");
                    bl2 = true;
                }
                if ((string2 = translationEntry.getGroup()) != null && !string2.equals(object3)) {
                    object3 = string2;
                    printWriter.println();
                    printWriter.println("\t\t//***************************************************************");
                    printWriter.println("\t\t//\tGroup: " + (String)object3);
                    printWriter.println("\t\t//***************************************************************");
                }
                printWriter.println();
                printWriter.println("\t\t/**");
                printWriter.println("\t\t *  " + translationEntry.getJavaDoc(this.doc.getLocales(), "\t\t *  ", this.doc));
                printWriter.println("\t\t */");
                printWriter.print("\t\t" + translationEntry.getGroupKey() + "(\"" + translationEntry.getKey() + "\")");
            }
            if (enum_ != null) {
                this.createEmumMethods(printWriter, (TranslationDataType)enum_);
            }
            printWriter.println("\t}");
            printWriter.println("}");
            printWriter.println();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return string;
    }

    private void createEmumMethods(PrintWriter printWriter, TranslationDataType translationDataType) {
        printWriter.println(";");
        printWriter.println();
        printWriter.println("\t\t/** Key of enum object, used in the ResourceBundle as key. */");
        printWriter.println("\t\tprivate final String key;");
        printWriter.println();
        printWriter.println("\t\t/**");
        printWriter.println("\t\t * Create new enum object with key.");
        printWriter.println("\t\t * @param key The key string used in the table.");
        printWriter.println("\t\t */");
        printWriter.println("\t\tprivate " + translationDataType.getPrefix() + " (final String key) {");
        printWriter.println("\t\t\tthis.key = key;");
        printWriter.println("\t\t}");
        printWriter.println();
        printWriter.println("\t\t/**");
        printWriter.println("\t\t * Return key of enum instance.");
        printWriter.println("\t\t * @return Is never null.");
        printWriter.println("\t\t */");
        printWriter.println("\t\tpublic String getKey () {");
        printWriter.println("\t\t\treturn key;");
        printWriter.println("\t\t}");
        printWriter.println();
        printWriter.println("\t\t/**");
        printWriter.println("\t\t * Returns the key of enum instance, of its name.");
        printWriter.println("\t\t * @returnIs never null. ");
        printWriter.println("\t\t */");
        printWriter.println("\t\t@Override public String toString () {");
        printWriter.println("\t\t\treturn getKey();");
        printWriter.println("\t\t}");
        printWriter.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createResourceFile(File file, int n, String string) throws IOException {
        boolean bl;
        Set<TranslationEntry> set = this.doc.getTranslations();
        PrintWriter printWriter = null;
        boolean bl2 = bl = n == -1;
        if (bl) {
            n = 0;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("java.util.ListResourceBundle");
        for (TranslationEntry object : set) {
            object.collectImports(treeSet, n, this.doc);
        }
        try {
            Locale locale = this.doc.getLocales().get(n).getLocale();
            String string2 = this.doc.getClassName() + (bl ? "" : "_" + locale.toString());
            File file2 = new File(file, string2 + ".java");
            printWriter = new PrintWriter(new BufferedWriter(new ASCIIFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), ENCODING))));
            printWriter.println("package " + this.doc.getPackageName() + ";");
            printWriter.println();
            for (String string3 : treeSet) {
                printWriter.println("import " + string3 + ";");
            }
            printWriter.println("\t/**");
            printWriter.println("\t * " + this.doc.getClassComment());
            printWriter.println("\t * Translations for " + locale.getDisplayName());
            printWriter.println("\t */");
            printWriter.println("public final class " + string2 + " extends ListResourceBundle");
            printWriter.println("{");
            printWriter.println();
            printWriter.println("\t/**");
            printWriter.println("\t * Access method to get the translation table.");
            printWriter.println("\t * @return The translation table.");
            printWriter.println("\t */");
            switch (this.param.getJdk()) {
                case JDK14: {
                    break;
                }
                default: {
                    printWriter.println("\t@Override");
                }
            }
            printWriter.println("\tpublic final Object[][] getContents()");
            printWriter.println("\t{");
            printWriter.println("\t\treturn CONTENTS;");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\t/**");
            printWriter.println("\t * The translation table.");
            printWriter.println("\t */");
            printWriter.println("\tprivate static final Object[][] CONTENTS =");
            printWriter.println("\t{");
            Object object = null;
            block11: for (TranslationEntry translationEntry : set) {
                if (!translationEntry.getType().isInResourceBundle()) continue;
                String string4 = translationEntry.getGroup();
                if (string4 != null && !string4.equals(object)) {
                    object = string4;
                    printWriter.println();
                    printWriter.println("\t\t//***************************************************************");
                    printWriter.println("\t\t//\tGroup: " + (String)object);
                    printWriter.println("\t\t//***************************************************************");
                }
                printWriter.println();
                printWriter.println("\t\t/**");
                printWriter.println("\t\t *  " + translationEntry.getJavaDoc(this.doc.getLocales(), "\t\t *  ", this.doc));
                printWriter.println("\t\t */");
                switch (this.param.getJdk()) {
                    case JDK14: {
                        printWriter.println("\t\t{ " + string + "." + translationEntry.getKey() + " , " + translationEntry.getValueAsString(n, this.doc) + " },");
                        continue block11;
                    }
                }
                printWriter.println("\t\t{ " + string + "." + translationEntry.getType().getPrefix() + "." + translationEntry.getGroupKey() + ".getKey() , " + translationEntry.getValueAsString(n, this.doc) + " },");
            }
            printWriter.println("\t};");
            printWriter.println();
            printWriter.println("}");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPluginProperties(int n) throws IOException {
        PrintWriter printWriter = null;
        try {
            String string;
            if (n == -1) {
                n = 0;
                string = "plugin.properties";
            } else {
                Locale locale = this.doc.getLocales().get(n).getLocale();
                string = "plugin_" + locale.toString() + ".properties";
            }
            File file = new File(this.param.getRcpPluginRoot(), string);
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Cant create path: '" + file2.getAbsolutePath() + "'");
            }
            String string2 = null;
            for (TranslationEntry translationEntry : this.doc.getTranslations()) {
                String string3 = translationEntry.getGroup();
                if (translationEntry.getType() != TranslationDataType.EclipseRCP) continue;
                if (printWriter == null) {
                    printWriter = new PrintWriter(new BufferedWriter(new ASCIIFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING))));
                }
                if (string3 != null && !string3.equals(string2)) {
                    string2 = string3;
                    printWriter.println("");
                    printWriter.println("#################################################################");
                    printWriter.println("#\tGroup: " + string2);
                    printWriter.println("#################################################################");
                }
                printWriter.println("");
                printWriter.println("#\t" + translationEntry.getPlainKey() + " (" + (Object)((Object)translationEntry.getType()) + ")");
                printWriter.println(translationEntry.getPlainKey() + "=" + translationEntry.getValueAsString(n, this.doc));
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

