/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.ASCIIFilterWriter;
import de.olafpanz.translationtable.CodeGenerator;
import de.olafpanz.translationtable.LocaleDef;
import de.olafpanz.translationtable.ODSLoader;
import de.olafpanz.translationtable.TranslationDataType;
import de.olafpanz.translationtable.TranslationDocument;
import de.olafpanz.translationtable.TranslationEntry;
import de.olafpanz.translationtable.TranslationTableParameters;
import de.olafpanz.xsd.translationTable100.LocaleType;
import de.olafpanz.xsd.translationTable100.TableFileType;
import de.olafpanz.xsd.translationTable100.TranslationTableType;
import de.olafpanz.xsd.translationTable100.TranslationTablesDocument;
import de.olafpanz.xsd.translationTable100.TranslationType;
import de.olafpanz.xsd.translationTable100.ValueType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.xml.sax.SAXException;

public final class CommandFacade {
    public static void exportXML(TranslationTableParameters translationTableParameters, File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            if (!file2.mkdirs()) {
                throw new IOException("Creation of path '" + file2.getAbsolutePath() + "' failed.");
            }
        } else if (!file2.isDirectory()) {
            throw new IOException("Specified path is a file: '" + file2.getAbsolutePath() + "'");
        }
        List<TranslationDocument> list = CommandFacade.loadDocuments(translationTableParameters);
        TranslationTablesDocument translationTablesDocument = CommandFacade.toXML(list);
        list.clear();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setCharacterEncoding("US-ASCII");
        xmlOptions.setSavePrettyPrint();
        xmlOptions.setSavePrettyPrintIndent(2);
        xmlOptions.setSavePrettyPrintOffset(2);
        translationTablesDocument.save(file, xmlOptions);
    }

    private static TranslationTablesDocument toXML(List<TranslationDocument> list) {
        TranslationTablesDocument translationTablesDocument = TranslationTablesDocument.Factory.newInstance();
        TableFileType tableFileType = translationTablesDocument.addNewTranslationTables();
        for (TranslationDocument translationDocument : list) {
            Object object;
            TranslationTableType translationTableType = tableFileType.addNewTranslationTable();
            translationTableType.setClassName(translationDocument.getClassName());
            translationTableType.setComment(translationDocument.getClassComment());
            translationTableType.setPackage(translationDocument.getPackageName());
            translationTableType.setName(translationDocument.getName());
            List<LocaleDef> list2 = translationDocument.getLocales();
            for (LocaleDef localeDef : list2) {
                Object object2 = translationTableType.addNewLocale();
                object2.setLocale(localeDef.getLocale().toString());
                if (localeDef.isDefault()) {
                    object2.setIsMasterLocale(true);
                }
                if ((object = localeDef.getTemplateLocale()) == null) continue;
                object2.setTemplateLocale(((Locale)object).toString());
            }
            int n = list2.size();
            for (Object object2 : translationDocument.getTranslations()) {
                TranslationType.DataType.Enum enum_;
                object = translationTableType.addNewTranslations();
                object.setKey(((TranslationEntry)object2).getPlainKey());
                object.setGroup(((TranslationEntry)object2).getGroup());
                switch (((TranslationEntry)object2).getType()) {
                    case Accelerator: {
                        enum_ = TranslationType.DataType.ACCELERATOR;
                        break;
                    }
                    case EclipseRCP: {
                        enum_ = TranslationType.DataType.ECLIPSE_RCP;
                        break;
                    }
                    case Mnemonic: {
                        enum_ = TranslationType.DataType.MNEMONIC;
                        break;
                    }
                    case Text: {
                        enum_ = TranslationType.DataType.TEXT;
                        break;
                    }
                    case Tooltip: {
                        enum_ = TranslationType.DataType.TOOLTIP;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknwon type: '" + (Object)((Object)((TranslationEntry)object2).getType()) + "'");
                    }
                }
                object.setDataType(enum_);
                List<String> list3 = ((TranslationEntry)object2).getTranslations();
                for (int i = 0; i < n; ++i) {
                    String string = list3.get(i);
                    if (string == null) continue;
                    ValueType valueType = object.addNewValue();
                    valueType.setLocale(list2.get(i).getLocale().toString());
                    valueType.setValue(ASCIIFilterWriter.convert(string));
                }
            }
        }
        translationTablesDocument.validate();
        return translationTablesDocument;
    }

    private static List<TranslationDocument> loadDocuments(TranslationTableParameters translationTableParameters) throws IOException {
        File file = translationTableParameters.getFile();
        if (file == null) {
            throw new IllegalArgumentException("No file specified for processing.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: '" + file.getAbsolutePath() + "'");
        }
        if (!file.getName().toLowerCase().endsWith("xml")) {
            try {
                return new ODSLoader(translationTableParameters).load();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException("Error in loading file '" + file.getAbsolutePath() + "': " + parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new IOException("Error in loading file '" + file.getAbsolutePath() + "': " + sAXException.getMessage(), sAXException);
            }
        }
        return CommandFacade.loadXml(file);
    }

    private static List<TranslationDocument> loadXml(File file) throws IOException {
        try {
            TranslationTablesDocument translationTablesDocument = TranslationTablesDocument.Factory.parse(file);
            TableFileType tableFileType = translationTablesDocument.getTranslationTables();
            ArrayList<TranslationDocument> arrayList = new ArrayList<TranslationDocument>();
            for (TranslationTableType translationTableType : tableFileType.getTranslationTableList()) {
                ArrayList<LocaleDef> arrayList2 = new ArrayList<LocaleDef>();
                TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                int n = 0;
                for (LocaleType localeType : translationTableType.getLocaleList()) {
                    Object object = new LocaleDef(ODSLoader.toLocale(localeType.getLocale()), ODSLoader.toLocale(localeType.getTemplateLocale()), localeType.getIsMasterLocale());
                    arrayList2.add((LocaleDef)object);
                    treeMap.put(localeType.getLocale(), n++);
                }
                TranslationDocument translationDocument = new TranslationDocument(translationTableType.getClassName(), translationTableType.getPackage(), translationTableType.getComment(), translationTableType.getName(), arrayList2);
                arrayList.add(translationDocument);
                for (Object object : translationTableType.getTranslationsList()) {
                    TranslationDataType translationDataType;
                    TranslationType.DataType.Enum enum_ = object.getDataType();
                    if (TranslationType.DataType.ACCELERATOR.equals(enum_)) {
                        translationDataType = TranslationDataType.Accelerator;
                    } else if (TranslationType.DataType.ECLIPSE_RCP.equals(enum_)) {
                        translationDataType = TranslationDataType.EclipseRCP;
                    } else if (TranslationType.DataType.MNEMONIC.equals(enum_)) {
                        translationDataType = TranslationDataType.Mnemonic;
                    } else if (TranslationType.DataType.TEXT.equals(enum_)) {
                        translationDataType = TranslationDataType.Text;
                    } else if (TranslationType.DataType.TOOLTIP.equals(enum_)) {
                        translationDataType = TranslationDataType.Tooltip;
                    } else {
                        throw new IllegalArgumentException("Unhandled type: '" + enum_ + "'");
                    }
                    String[] stringArray = new String[treeMap.size()];
                    for (ValueType valueType : object.getValueList()) {
                        Integer n2 = (Integer)treeMap.get(valueType.getLocale());
                        if (n2 == null) {
                            throw new IOException("Locale '" + valueType.getLocale() + "' not specified in locale section of file.");
                        }
                        stringArray[n2.intValue()] = valueType.getValue();
                    }
                    TranslationEntry translationEntry = new TranslationEntry(object.getKey(), object.getGroup(), translationDataType, object.getDescription(), Arrays.asList(stringArray));
                    translationDocument.addTranslation(translationEntry);
                }
            }
            return arrayList;
        }
        catch (XmlException xmlException) {
            throw new IOException("Error in loading file '" + file.getAbsolutePath() + "': " + xmlException.getMessage(), xmlException);
        }
    }

    public static void createCode(TranslationTableParameters translationTableParameters) throws IOException {
        List<TranslationDocument> list = CommandFacade.loadDocuments(translationTableParameters);
        for (TranslationDocument translationDocument : list) {
            CodeGenerator codeGenerator = new CodeGenerator(translationDocument, translationTableParameters);
            codeGenerator.createFiles();
        }
    }
}

