/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.CommandFacade;
import de.olafpanz.translationtable.Environment;
import de.olafpanz.translationtable.JDKDefine;
import de.olafpanz.translationtable.TranslationTableParameters;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class I18NTask
extends Task {
    private final TranslationTableParameters params = new TranslationTableParameters();

    public void execute() throws BuildException {
        try {
            CommandFacade.createCode(this.params);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new BuildException("I18N failed", throwable);
        }
    }

    public void setODSFile(String string) {
        this.params.setOds(new File(string));
    }

    public void setJDK(String string) {
        JDKDefine jDKDefine;
        if ("1.4".equals(string) || "4".equals(string)) {
            jDKDefine = JDKDefine.JDK14;
        } else if ("1.5".equals(string) || "5".equals(string)) {
            jDKDefine = JDKDefine.JDK15;
        } else if ("1.6".equals(string) || "6".equals(string)) {
            jDKDefine = JDKDefine.JDK15;
        } else {
            throw new BuildException("Unknown JDK: '" + string + "'");
        }
        this.params.setJdk(jDKDefine);
    }

    public void setEnvironment(String string) {
        Environment environment;
        if (string.equalsIgnoreCase("server")) {
            environment = Environment.Server;
        } else if (string.equalsIgnoreCase("client")) {
            environment = Environment.Client;
        } else {
            throw new BuildException("Unknown environment: '" + string + "'");
        }
        this.params.setEnvironment(environment);
    }

    public void setRcpPluginRoot(String string) {
        this.params.setRcpPluginRoot(new File(string));
    }

    public void setSourceRoot(String string) {
        this.params.setSourceRoot(new File(string));
    }
}

