/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.LocaleDef;
import de.olafpanz.translationtable.TranslationDataType;
import de.olafpanz.translationtable.TranslationDocument;
import de.olafpanz.translationtable.TranslationEntry;
import de.olafpanz.translationtable.TranslationTableParameters;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ODSLoader {
    private static final String CONTENT_NAME = "content.xml";
    private Document doc;
    private final TranslationTableParameters param;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TranslationDocument> load() throws IOException, ParserConfigurationException, SAXException {
        List<TranslationDocument> list = null;
        String string = this.param.isComplete();
        if (string != null) {
            throw new IllegalArgumentException("Parameters are incomplete: " + string);
        }
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.param.getFile())));
            System.out.println("Processing (" + (Object)((Object)this.param.getJdk()) + "," + (Object)((Object)this.param.getEnvironment()) + "): " + this.param.getFile().getAbsolutePath());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (CONTENT_NAME.equals(zipEntry.getName())) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setIgnoringComments(true);
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    this.doc = documentBuilder.parse(zipInputStream);
                    list = this.readSheet();
                    break;
                }
                zipInputStream.closeEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        return list;
    }

    public ODSLoader(TranslationTableParameters translationTableParameters) {
        if (translationTableParameters == null) {
            throw new IllegalArgumentException("param is null.");
        }
        this.param = translationTableParameters;
    }

    static final Locale toLocale(String string) {
        Locale locale;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("_");
        switch (stringArray.length) {
            case 1: {
                locale = new Locale(stringArray[0]);
                break;
            }
            case 2: {
                locale = new Locale(stringArray[0], stringArray[1]);
                break;
            }
            case 3: {
                locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                break;
            }
            default: {
                locale = null;
            }
        }
        return locale;
    }

    private final String readCellValue(NodeList nodeList, int n, int n2) {
        Object object;
        Object object2;
        int n3;
        if (n >= nodeList.getLength()) {
            return null;
        }
        NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("table:table-cell");
        int n4 = 0;
        int n5 = nodeList2.getLength();
        for (n3 = 0; n3 < n5; ++n3) {
            object2 = (Element)nodeList2.item(n3);
            object = object2.getAttribute("table:number-columns-repeated");
            n4 = object != null && ((String)object).length() > 0 ? (n4 += Integer.parseInt((String)object)) : ++n4;
            if (n2 < n4) break;
        }
        if (n3 >= nodeList2.getLength()) {
            return null;
        }
        object2 = ((Element)nodeList2.item(n3)).getElementsByTagName("text:p");
        if (object2.getLength() == 0) {
            return null;
        }
        object = (Element)object2.item(0);
        String string = object.getTextContent();
        return string;
    }

    private final List<TranslationDocument> readSheet() {
        Element element = this.doc.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName("office:body").item(0);
        Element element3 = (Element)element2.getElementsByTagName("office:spreadsheet").item(0);
        NodeList nodeList = element3.getElementsByTagName("table:table");
        ArrayList<TranslationDocument> arrayList = new ArrayList<TranslationDocument>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            TranslationDocument translationDocument = this.readTable((Element)nodeList.item(i));
            arrayList.add(translationDocument);
        }
        return arrayList;
    }

    private final TranslationDocument readTable(Element element) {
        Object object;
        Object object2;
        String string = element.getAttribute("table:name");
        System.out.println("    " + string);
        NodeList nodeList = element.getElementsByTagName("table:table-row");
        if (nodeList.getLength() < 6) {
            System.err.println(string + " does not contain translation data.");
            return null;
        }
        String string2 = this.readCellValue(nodeList, 1, 1);
        if (string2 == null) {
            System.err.println(string + ": Package name not specified! (Cell B2)");
            return null;
        }
        String string3 = this.readCellValue(nodeList, 2, 1);
        if (string3 == null) {
            System.err.println(string + ": Name not specified! (Cell B3)");
            return null;
        }
        String string4 = this.readCellValue(nodeList, 3, 1);
        if (string4 == null) {
            System.err.println(string + ":  Class-comment is missing! (Cell B4)");
            return null;
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        while ((object2 = this.readCellValue(nodeList, 5, 4 + arrayList.size())) != null) {
            Locale locale = ODSLoader.toLocale((String)object2);
            if (locale == null) {
                System.err.println(string + ": Error in Locale format: \"" + (String)object2 + "\"");
                return null;
            }
            arrayList.add(locale);
        }
        object2 = new ArrayList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string5 = this.readCellValue(nodeList, 6, 4 + i);
            object = string5 == null ? null : ODSLoader.toLocale(string5);
            object2.add(new LocaleDef((Locale)arrayList.get(i), (Locale)object, i == 0));
        }
        TranslationDocument translationDocument = new TranslationDocument(string3, string2, string4, string, (List<LocaleDef>)object2);
        int n2 = 7;
        while ((object = this.readCellValue(nodeList, n2, 0)) != null) {
            String string6 = this.readCellValue(nodeList, n2, 1);
            String string7 = this.readCellValue(nodeList, n2, 2);
            if (string7 == null) {
                System.err.println(string + ": No type defined for: \"" + (String)object + "\" row is ignored!");
                ++n2;
                continue;
            }
            TranslationDataType translationDataType = TranslationDataType.valueOf(string7);
            if (translationDataType == null) {
                System.err.println(string + ": Type undefined: \"" + string7 + "\" for: \"" + (String)object + "\" row is ignored!");
                ++n2;
                continue;
            }
            String string8 = TranslationEntry.createKey(translationDataType, string6, (String)object);
            String string9 = this.readCellValue(nodeList, n2, 3);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                String string10 = this.readCellValue(nodeList, n2, 4 + i);
                if (string10 == null || string10.length() == 0) {
                    string10 = null;
                }
                arrayList2.add(string10);
            }
            TranslationEntry translationEntry = new TranslationEntry((String)object, string6, translationDataType, string9, arrayList2);
            if (!translationDocument.addTranslation(translationEntry)) {
                System.err.println(string + ": double key in table :\"" + string8 + "\" The last will win!");
            }
            ++n2;
        }
        return translationDocument;
    }
}

