/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.LocaleDef;
import de.olafpanz.translationtable.TranslationEntry;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

final class TranslationDocument {
    private final Set<TranslationEntry> translations = new TreeSet<TranslationEntry>();
    private final List<LocaleDef> locales;
    private final String name;
    private final String packageName;
    private final String className;
    private final String classComment;
    private final int[] templateLocales;

    private static int getIndex(List<LocaleDef> list, Locale locale) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getLocale().equals(locale)) continue;
            return i;
        }
        return -1;
    }

    public TranslationDocument(String string, String string2, String string3, String string4, List<LocaleDef> list) {
        Iterator<LocaleDef> iterator;
        int n;
        this.classComment = string3;
        this.className = string;
        this.locales = list;
        this.name = string4;
        this.packageName = string2;
        this.templateLocales = new int[list.size()];
        for (n = 0; n < this.templateLocales.length; ++n) {
            iterator = list.get(n);
            Locale locale = ((LocaleDef)((Object)iterator)).getTemplateLocale();
            this.templateLocales[n] = -1;
            if (locale == null) continue;
            this.templateLocales[n] = TranslationDocument.getIndex(list, locale);
            if (this.templateLocales[n] != -1) continue;
            throw new IllegalArgumentException("Default locale '" + locale + "' for locale '" + list.get(n) + "' not found.");
        }
        for (n = 0; n < this.templateLocales.length; ++n) {
            iterator = new TreeSet();
            int n2 = n;
            do {
                if (iterator.contains(n2)) {
                    throw new IllegalArgumentException("Circular default locale dependencies for '" + list.get(n));
                }
                iterator.add((LocaleDef)((Object)Integer.valueOf(n2)));
            } while ((n2 = this.templateLocales[n2]) >= 0);
        }
        n = 0;
        for (LocaleDef localeDef : list) {
            if (!localeDef.isDefault()) continue;
            if (n != 0) {
                throw new IllegalArgumentException("Table has multiple master-locales, only one is allowed.");
            }
            n = 1;
        }
    }

    public Set<TranslationEntry> getTranslations() {
        return Collections.unmodifiableSet(this.translations);
    }

    public int getTemplateLocaleIndex(int n) {
        return this.templateLocales[n];
    }

    public int getDefaultLocale() {
        int n = this.locales.size();
        for (int i = 0; i < n; ++i) {
            if (!this.locales.get(i).isDefault()) continue;
            return i;
        }
        return 0;
    }

    public List<LocaleDef> getLocales() {
        return Collections.unmodifiableList(this.locales);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public boolean addTranslation(TranslationEntry translationEntry) {
        return this.translations.add(translationEntry);
    }

    public boolean hasBundle() {
        for (TranslationEntry translationEntry : this.translations) {
            switch (translationEntry.getType()) {
                case Accelerator: {
                    return true;
                }
                case Mnemonic: {
                    return true;
                }
                case Text: {
                    return true;
                }
                case Tooltip: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasRCP() {
        for (TranslationEntry translationEntry : this.translations) {
            switch (translationEntry.getType()) {
                case Accelerator: {
                    break;
                }
                case Mnemonic: {
                    break;
                }
                case Text: {
                    break;
                }
                case Tooltip: {
                    break;
                }
                case EclipseRCP: {
                    return true;
                }
            }
        }
        return false;
    }
}

