/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.LocaleDef;
import de.olafpanz.translationtable.TranslationDataType;
import de.olafpanz.translationtable.TranslationDocument;
import java.util.List;
import java.util.Set;

final class TranslationEntry
implements Comparable<TranslationEntry> {
    private final String key;
    private final TranslationDataType type;
    private final String desc;
    private final List<String> translations;
    private final String group;

    public static String createKey(TranslationDataType translationDataType, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(translationDataType.getPrefix()).append('_');
        if (string != null) {
            stringBuilder.append(string.replace('.', '_')).append('_');
        }
        stringBuilder.append(string2.replace('.', '_'));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getKey();
    }

    public TranslationEntry(String string, String string2, TranslationDataType translationDataType, String string3, List<String> list) {
        assert (string != null);
        assert (translationDataType != null);
        assert (string3 != null);
        assert (list != null);
        this.key = string;
        this.group = string2;
        this.type = translationDataType;
        this.desc = string3;
        this.translations = list;
    }

    @Override
    public int compareTo(TranslationEntry translationEntry) {
        String string = this.getGroup();
        String string2 = translationEntry.getGroup();
        int n = 0;
        if (string == null && string2 != null) {
            n = -1;
        } else if (string != null && string2 == null) {
            n = 1;
        }
        if (n == 0 && string != null) {
            n = this.getGroup().compareTo(translationEntry.getGroup());
        }
        if (n == 0 && (n = this.getPlainKey().compareTo(translationEntry.getPlainKey())) == 0) {
            n = this.getType().compareTo(translationEntry.getType());
        }
        return n;
    }

    private final String convert2Character(String string) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new Character ('");
        boolean bl2 = bl = string.startsWith("\\u") && string.length() == 6;
        if (string.length() != 1 && !bl) {
            stringBuilder.append('?');
            System.err.println("Only one character is allowed for mnemonics, buf found '" + string + "' for key '" + this.getGroupKey() + "'");
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append("')");
        return stringBuilder.toString();
    }

    private final String convert2KeyStroke(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = null;
        for (String string3 : stringArray = string.toUpperCase().split("\\+")) {
            String string4 = string3.trim();
            if ("SHIFT".equals(string4)) {
                bl = true;
                continue;
            }
            if ("CTRL".equals(string4)) {
                bl2 = true;
                continue;
            }
            if ("META".equals(string4)) {
                bl3 = true;
                continue;
            }
            if ("ALT".equals(string4)) {
                bl4 = true;
                continue;
            }
            if (string4.startsWith("\\U")) {
                bl5 = true;
                string2 = string4.toLowerCase();
                continue;
            }
            bl5 = false;
            string2 = string4.startsWith("VK_") ? string4 : "VK_" + string4;
        }
        if (!bl5 && string2 == null) {
            System.err.println(string2 + ": Invalid key stroke definition for accelerator: \"" + string + "\"");
            return "null";
        }
        stringBuilder.append("KeyStroke.getKeyStroke (");
        if (bl5) {
            stringBuilder.append("new Character ('");
            stringBuilder.append(string2);
            stringBuilder.append("')");
        } else {
            stringBuilder.append("KeyEvent.");
            stringBuilder.append(string2);
        }
        stringBuilder.append(",");
        boolean bl6 = false;
        if (bl) {
            stringBuilder.append("InputEvent.SHIFT_MASK");
            bl6 = true;
        }
        if (bl2) {
            if (bl6) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("InputEvent.CTRL_MASK");
            bl6 = true;
        }
        if (bl3) {
            if (bl6) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("InputEvent.META_MASK");
            bl6 = true;
        }
        if (bl4) {
            if (bl6) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append("InputEvent.ALT_MASK");
            bl6 = true;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getDesc() {
        return this.desc;
    }

    public String getJavaDoc(List<LocaleDef> list, String string, TranslationDocument translationDocument) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDesc()).append(" (").append((Object)this.getType()).append(")");
        stringBuilder.append("\n").append(string).append("Translations:");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("\n").append(string).append("   ").append(list.get(i).getLocale().getDisplayName()).append(": \"").append(this.getRawTranslationString(i, translationDocument)).append("\"");
        }
        return stringBuilder.toString();
    }

    public String getGroup() {
        return this.group;
    }

    public String getKey() {
        return TranslationEntry.createKey(this.type, this.group, this.getPlainKey());
    }

    public String getGroupKey() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.group != null) {
            stringBuilder.append(this.group.replace('.', '_')).append('_');
        }
        stringBuilder.append(this.key.replace('.', '_'));
        return stringBuilder.toString();
    }

    public String getPlainKey() {
        return this.key;
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public TranslationDataType getType() {
        return this.type;
    }

    private String getRawTranslationString(int n, TranslationDocument translationDocument) {
        String string = null;
        int n2 = n;
        while ((string = this.translations.get(n2)) == null && (n2 = translationDocument.getTemplateLocaleIndex(n2)) >= 0) {
        }
        return string;
    }

    public String getValueAsString(int n, TranslationDocument translationDocument) {
        String string;
        String string2 = this.getRawTranslationString(n, translationDocument);
        if (string2 == null) {
            string = "null";
        } else {
            switch (this.type) {
                case Text: 
                case Tooltip: {
                    string = "\"" + string2 + "\"";
                    break;
                }
                case Accelerator: {
                    string = this.convert2KeyStroke(string2);
                    break;
                }
                case Mnemonic: {
                    string = this.convert2Character(string2);
                    break;
                }
                case EclipseRCP: {
                    string = string2;
                    break;
                }
                default: {
                    assert (false) : "Unhandled type!: " + (Object)((Object)this.type);
                    string = "null";
                }
            }
        }
        return string;
    }

    public void collectImports(Set<String> set, int n, TranslationDocument translationDocument) {
        String string = this.getValueAsString(n, translationDocument);
        if (string.contains("InputEvent")) {
            set.add("java.awt.event.InputEvent");
        }
        if (string.contains("KeyStroke")) {
            set.add("javax.swing.KeyStroke");
        }
        if (string.contains("KeyEvent")) {
            set.add("java.awt.event.KeyEvent");
        }
    }
}

