/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.CommandFacade;
import de.olafpanz.translationtable.Environment;
import de.olafpanz.translationtable.JDKDefine;
import de.olafpanz.translationtable.TranslationTableParameters;
import java.io.File;
import java.io.IOException;

final class TranslationTableMain {
    TranslationTableMain() {
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("TranslationTable (c) 2005-2008 by Olaf Panz");
        TranslationTableParameters translationTableParameters = new TranslationTableParameters();
        String string = System.getProperty("user.dir");
        ArgumentState argumentState = ArgumentState.Default;
        if (stringArray.length == 0) {
            TranslationTableMain.printHelp();
        }
        block12: for (String string2 : stringArray) {
            ArgumentState argumentState2 = argumentState;
            argumentState = ArgumentState.Default;
            switch (argumentState2) {
                case Default: {
                    if ("-h".equals(string2)) {
                        TranslationTableMain.printHelp();
                        continue block12;
                    }
                    if ("-ods".equals(string2)) {
                        argumentState = ArgumentState.ReadODS;
                        continue block12;
                    }
                    if ("-xml".equals(string2)) {
                        argumentState = ArgumentState.ReadXML;
                        continue block12;
                    }
                    if ("-as".equals(string2)) {
                        argumentState = ArgumentState.AbsoluteSourcePath;
                        continue block12;
                    }
                    if ("-rs".equals(string2)) {
                        argumentState = ArgumentState.RelativeSourcePath;
                        continue block12;
                    }
                    if ("-ae".equals(string2)) {
                        argumentState = ArgumentState.AbsoluteRCPPath;
                        continue block12;
                    }
                    if ("-re".equals(string2)) {
                        argumentState = ArgumentState.RelativeRCPPath;
                        continue block12;
                    }
                    if ("-axe".equals(string2)) {
                        argumentState = ArgumentState.AbsoluteXMLExport;
                        continue block12;
                    }
                    if ("-rxe".equals(string2)) {
                        argumentState = ArgumentState.RelativeXMLExport;
                        continue block12;
                    }
                    if ("-jdk".equals(string2)) {
                        argumentState = ArgumentState.JDK;
                        continue block12;
                    }
                    if ("-server".equals(string2)) {
                        translationTableParameters.setEnvironment(Environment.Server);
                        continue block12;
                    }
                    if ("-client".equals(string2)) {
                        translationTableParameters.setEnvironment(Environment.Client);
                        continue block12;
                    }
                    if ("-codegen".equals(string2)) {
                        CommandFacade.createCode(translationTableParameters);
                        continue block12;
                    }
                    TranslationTableMain.printHelp();
                    throw new IllegalArgumentException("Unknown parameter: " + string2);
                }
                case JDK: {
                    if (string2.indexOf(52) != -1) {
                        translationTableParameters.setJdk(JDKDefine.JDK14);
                        continue block12;
                    }
                    translationTableParameters.setJdk(JDKDefine.JDK15);
                    continue block12;
                }
                case AbsoluteSourcePath: {
                    translationTableParameters.setSourceRoot(new File(string2));
                    continue block12;
                }
                case RelativeSourcePath: {
                    translationTableParameters.setSourceRoot(new File(string, string2));
                    continue block12;
                }
                case AbsoluteRCPPath: {
                    translationTableParameters.setRcpPluginRoot(new File(string2));
                    continue block12;
                }
                case RelativeRCPPath: {
                    translationTableParameters.setRcpPluginRoot(new File(string, string2));
                    continue block12;
                }
                case ReadODS: {
                    translationTableParameters.setOds(new File(string, string2));
                    continue block12;
                }
                case ReadXML: {
                    translationTableParameters.setXml(new File(string, string2));
                    continue block12;
                }
                case AbsoluteXMLExport: {
                    CommandFacade.exportXML(translationTableParameters, new File(string2));
                    continue block12;
                }
                case RelativeXMLExport: {
                    CommandFacade.exportXML(translationTableParameters, new File(string, string2));
                }
            }
        }
    }

    private static void printHelp() {
        System.out.println("Parameter:-h:       Print this help text.");
        System.out.println("          -as <path> Specify a absolute target base path. This path is extended by package structure. Default is ods-file's path + 'source/main/java'.");
        System.out.println("          -rs <path> Specify a relative target base path. This path is relative to user.dir");
        System.out.println("          -ae <path> Specify a absolute rcp plugin base path. Default is path of ods file.");
        System.out.println("          -re <path> Specify a relative rcp plugin base path. This path is relative to user.dir.");
        System.out.println("          -axe <file> Export loaded tables in xml format. Specify target absolute.");
        System.out.println("          -rxe <file> Export loaded tables in xml format. Specify target absolute.");
        System.out.println("          -jdk <4/5>       Create source code for jdk 1.4 or 1.5. Default is 1.5.");
        System.out.println("          -server          Create source for server environment, default is client.");
        System.out.println("          -client          Create source for client environment, this is the default .");
        System.out.println("          -rcp <RCP Root>  Set the Eclipse-RCP base path needed to write i18n property files.");
        System.out.println("          -ods <file>      Specify OpenOffice Calc (ODS) file for processing.");
        System.out.println("          -xml <file>      Specify XML file for processing.");
        System.out.println("          -codegen      Generate code with parameters specified before.");
        System.out.println("Parameters can be added in any order. A target path is used until the next is specified.");
    }

    private static enum ArgumentState {
        Default,
        AbsoluteXMLExport,
        RelativeXMLExport,
        JDK,
        AbsoluteSourcePath,
        RelativeSourcePath,
        AbsoluteRCPPath,
        RelativeRCPPath,
        ReadODS,
        ReadXML;

    }
}

