/*
 * Decompiled with CFR 0.152.
 */
package de.olafpanz.translationtable;

import de.olafpanz.translationtable.Environment;
import de.olafpanz.translationtable.JDKDefine;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;

public class TranslationTableParameters {
    private final Set<DefaultFlags> defaults = EnumSet.noneOf(DefaultFlags.class);
    private File sourceRoot;
    private File rcpPluginRoot;
    private File file;
    private JDKDefine jdk;
    private Environment env;

    public String isComplete() {
        if (this.file == null) {
            return "No file is set for processing.";
        }
        if (!this.file.exists()) {
            return "File '" + this.file + "' does not exist.";
        }
        return null;
    }

    public TranslationTableParameters() {
        this.setDefault();
    }

    public TranslationTableParameters(Environment environment, JDKDefine jDKDefine, File file, File file2, File file3) {
        this();
        this.setOds(file);
        this.setEnvironment(environment);
        this.setJdk(jDKDefine);
        this.setRcpPluginRoot(file2);
        this.setSourceRoot(file3);
    }

    public void setDefault() {
        this.rcpPluginRoot = this.sourceRoot = new File("user.dir");
        this.file = null;
        this.jdk = JDKDefine.JDK15;
        this.env = Environment.Client;
        this.defaults.addAll(EnumSet.allOf(DefaultFlags.class));
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Set null to source root");
        }
        this.defaults.remove((Object)DefaultFlags.SourceRootIsDefault);
        this.sourceRoot = file;
    }

    public File getRcpPluginRoot() {
        return this.rcpPluginRoot;
    }

    public void setRcpPluginRoot(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Set null to rcp-plugin-root");
        }
        this.defaults.remove((Object)DefaultFlags.RcpPluginIsDefault);
        this.rcpPluginRoot = file;
    }

    private void setDefaultRcpPluginRoot(File file) {
        if (this.defaults.contains((Object)DefaultFlags.RcpPluginIsDefault)) {
            this.rcpPluginRoot = file;
        }
    }

    private void setDefaultSourceRoot(File file) {
        if (this.defaults.contains((Object)DefaultFlags.SourceRootIsDefault)) {
            File file2;
            this.sourceRoot = file2 = new File(file, "source" + File.separator + "main" + File.separator + "java");
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setXml(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Set null to xml-file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Specified XML file '" + file + "' does not exists.");
        }
        this.setDefaultRcpPluginRoot(file.getParentFile());
        this.setDefaultSourceRoot(file.getParentFile());
        this.file = file;
    }

    public void setOds(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Set null to ods-file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Specified ODS file '" + file + "' does not exists.");
        }
        this.setDefaultRcpPluginRoot(file.getParentFile());
        this.setDefaultSourceRoot(file.getParentFile());
        this.file = file;
    }

    public JDKDefine getJdk() {
        return this.jdk;
    }

    public void setJdk(JDKDefine jDKDefine) {
        if (jDKDefine == null) {
            throw new IllegalArgumentException("jdk is null");
        }
        this.jdk = jDKDefine;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void setEnvironment(Environment environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Env is null.");
        }
        this.env = environment;
    }

    private static enum DefaultFlags {
        SourceRootIsDefault,
        RcpPluginIsDefault;

    }
}

