package de.olafpanz.translationtable;

import java.util.Locale;

/**
 * Defines a locale for the TranslationDocument
 * 
 * @author Olaf
 * 
 */
final class LocaleDef implements Comparable<LocaleDef> {
    /**
     * The locale of this definition
     */
    private final Locale locale;

    /**
     * Use translation from this locale, if no value exists.
     */
    private final Locale templateLocale;

    /**
     * Marks the master locale of current table
     */
    private final boolean isMaster;

    /**
     * Create new locale definition
     * 
     * @param locale
     *                The locale of this definition
     * @param templateLocale
     *                Use translation from this locale, if no value exists.
     * @param isMaster
     *                Marks the master locale of current table
     */
    public LocaleDef(final Locale locale, final Locale templateLocale,
	    final boolean isMaster) {

	this.templateLocale = templateLocale;
	this.isMaster = isMaster;
	this.locale = locale;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

	return locale.toString() + "(" + isMaster + ", " + templateLocale + ")";
    }

    /**
     * @return The locale of this definition
     */
    public Locale getLocale() {
	return locale;
    }

    /**
     * 
     * @return Use translation from this locale, if no value exists.
     */
    public Locale getTemplateLocale() {
	return templateLocale;
    }

    /**
     * @return Marks the master locale of current table
     */
    public boolean isDefault() {
	return isMaster;
    }

    /**
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(final LocaleDef def) {
	final Locale l1 = def.getLocale();

	int result = cmp(locale.getVariant(), l1.getVariant());
	if (result == 0) {
	    result = cmp(locale.getCountry(), l1.getCountry());
	}
	if (result == 0) {
	    result = cmp(locale.getLanguage(), l1.getLanguage());
	}
	return result;

    }

    /**
     * Compare 2 strings allowing null.
     * 
     * @param s0
     *                First string
     * @param s1
     *                Second string
     * @return Handles null as smaller as not null
     */
    private final int cmp(final String s0, final String s1) {
	if (s0 == null || s0.isEmpty()) {
	    if (s1 != null && !s1.isEmpty()) {
		return -1;
	    }
	    return 0;
	}
	if (s1 == null || s1.isEmpty()) {
	    return 1;
	}
	return s0.compareTo(s1);
    }

}
