/**
 * Copyright 2005-2008 Olaf Panz 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package de.olafpanz.translationtable;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Privde I18N code generator as ant task.
 * 
 * @author Olaf Panz
 */
public final class SvnReleaseTask extends Task {

    /**
     * Text result from svn info
     */
    private String infoText;

    /**
     * Name of result variable.
     */
    private String resultVariable;

    /**
     * @param resultVariable
     *                Name of result variable.
     */
    public void setResultVariable(final String resultVariable) {
	this.resultVariable = resultVariable;
    }

    /**
     * @param infoText
     *                Text result from svn info
     */
    public void setInfoText(final String infoText) {
	this.infoText = infoText;
    }

    /**
     * Do filter
     * 
     * @see org.apache.tools.ant.Task#execute()
     */
    @Override
    public void execute() throws BuildException {
	if (infoText == null || infoText.isEmpty()) {
	    throw new BuildException("infoText is not set.");
	}
	if (resultVariable == null || resultVariable.isEmpty()) {
	    throw new BuildException("resultVariable is not set.");
	}
	final LineNumberReader reader = new LineNumberReader(new StringReader(
		infoText));
	String result = null;
	try {
	    while (reader.ready()) {
		final String line = reader.readLine();
		final String parts[] = line.split(":");
		if ("Revision".equals(parts[0].trim())) {
		    result = parts[1].trim();
		    break;
		}
	    }
	} catch (final IOException e) {
	    throw new BuildException("Parsing of '" + infoText + "' failed.", e);
	}
	if (result == null) {
	    throw new BuildException("No revision found in '" + infoText + "'.");
	}
	System.out.println("Found Revision:" + result);
	getProject().setProperty(resultVariable, result);

    }

}
