/**
 * Copyright 2005-2008 Olaf Panz 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */

package de.olafpanz.translationtable;

/**
 * Defines all type of translations.
 * 
 * @author Olaf Panz
 * 
 */
enum TranslationDataType {
    /**
     * Create translation entry for plain text, use prefix "TX_"
     */
    Text("TX", true),
    /**
     * Create a tooltip, use prefix "TT_"
     */
    Tooltip("TT", true),
    /**
     * Create an accelerator, use prefix "AC_" and create object
     */
    Accelerator("AC", true),
    /**
     * Create a mnemonic, use Character as object.
     */
    Mnemonic("MN", true),
    /**
     * Type is eclipse RCP
     */
    EclipseRCP("RCP", false);

    /**
     * The prefix, needed for generation
     */
    private final String prefix;
    /**
     * True, if this element is part of resource bundle.
     */
    private final boolean isInResourceBundle;

    /**
     * Create a data type
     * 
     * @param prefix
     *                The prefix, needed for generation
     * @param isInResourceBundle
     *                True, if this element is part of resource bundle.
     */
    private TranslationDataType(final String prefix,
	    final boolean isInResourceBundle) {
	assert prefix != null;

	this.isInResourceBundle = isInResourceBundle;
	this.prefix = prefix;

    }

    /**
     * 
     * @return True, if this element is part of resource bundle.
     */
    public boolean isInResourceBundle() {
	return isInResourceBundle;
    }

    /**
     * 
     * @return The prefix, needed for generation
     */
    public String getPrefix() {
	return prefix;
    }

}
