package de.olafpanz.translationtable;

import java.io.IOException;
import java.io.StringWriter;

import junit.framework.TestCase;

/**
 * Test ascii conversion
 * 
 * @author Olaf
 * 
 */
public class ASCIIFilterWriterTest extends TestCase {

    /**
     * Test string conversions.
     * 
     * @throws IOException
     *                 Error in string handling
     */
    public void testConversion() throws IOException {
	doWriterConvertTest("", "\\u00f6\\u00e4\\u00fc\\u00df");
	doWriterTest("a\"x", "a\"x");
	doConvertTest("a\"x", "a\\u0022x");
    }

    /**
     * Test conversion with both conversion methods.
     * 
     * @param inp
     *                The input string
     * @param expected
     *                The expected result
     * @throws IOException
     *                 Error in string handling
     */
    private void doWriterConvertTest(final String inp, final String expected)
	    throws IOException {
	doWriterTest(inp, expected);
	doConvertTest(inp, expected);
    }

    /**
     * Test conversion with writer.
     * 
     * @param inp
     *                The input string
     * @param expected
     *                The expected result
     * @throws IOException
     *                 Error in string handling
     */
    private void doWriterTest(final String inp, final String expected)
	    throws IOException {
	final StringWriter strw = new StringWriter();
	final ASCIIFilterWriter writer = new ASCIIFilterWriter(strw);
	writer.write(inp);
	writer.close();
	final String result = strw.toString();
	assertEquals("Test with stream, input: '" + inp + "'", expected, result);
    }

    /**
     * Test conversion with convert.
     * 
     * @param inp
     *                The input string
     * @param expected
     *                The expected result
     */
    private void doConvertTest(final String inp, final String expected) {
	final String result2 = ASCIIFilterWriter.convert(inp);
	assertEquals("Test with convert(), input: '" + inp + "'", expected,
		result2);

    }
}
