package de.olafpanz.translationtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import junit.framework.TestCase;

/**
 * Test locale comparator
 * 
 * @author Olaf
 * 
 */
public class LocaleComparatorTest extends TestCase {

    /**
     * Test ordering of comparator
     */
    public void testOrder() {
	final List<LocaleDef> locales = new ArrayList<LocaleDef>();

	for (final Locale loc : Locale.getAvailableLocales()) {
	    locales.add(new LocaleDef(loc, null, false));

	}

	locales.add(new LocaleDef(new Locale("de", "DE", "XX"), null, false));
	locales.add(new LocaleDef(new Locale("de", "DE", "YY"), null, false));

	Collections.shuffle(locales);
	Collections.sort(locales);

	final Locale first = locales.get(0).getLocale();

	assertNotSame("", first.getLanguage());
	assertEquals("", first.getCountry());
	assertEquals("", first.getVariant());

	final Locale last = locales.get(locales.size() - 1).getLocale();
	assertNotSame("", last.getLanguage());
	assertNotSame("", last.getCountry());
	assertNotSame("", last.getVariant());

	// System.out.println("locales: " + locales);

    }
}
