package de.olafpanz.translationtable;

import java.io.File;

import junit.framework.TestCase;

/**
 * Test class TranslationTableParameter.
 * 
 * @author Olaf
 * 
 */
public class TranslationTableParameterTest extends TestCase {
    /**
     * Test default value handling
     */
    public void testDefaults() {
	final String usrDir = System.getProperty("user.dir");

	// test setting of default
	TranslationTableParameters params = new TranslationTableParameters();
	params.setOds(new File(usrDir, "TestJDK1.4-client.ods"));

	assertEquals(new File(usrDir), params.getRcpPluginRoot());
	assertEquals(new File(usrDir, "source" + File.separator + "main"
		+ File.separator + "java"), params.getSourceRoot());
	assertEquals(new File(usrDir, "TestJDK1.4-client.ods"), params
		.getFile());

	// test that setted values are not overwritten by default-settinh
	params = new TranslationTableParameters();
	final File tmpPath = new File(System.getProperty("java.io.tmpdir"));
	final File srcPath = new File(tmpPath, "a");
	params.setSourceRoot(srcPath);
	params.setRcpPluginRoot(tmpPath);
	params.setOds(new File(usrDir, "TestJDK1.4-client.ods"));

	assertEquals(tmpPath, params.getRcpPluginRoot());
	assertEquals(srcPath, params.getSourceRoot());
	assertEquals(new File(usrDir, "TestJDK1.4-client.ods"), params
		.getFile());

    }

}
