package de.olafpanz.translationtable.test;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import de.olafpanz.translationtable.test.server14.TestServer14TranslationManager;

/**
 * Test tanslations in multitheadded environment.
 * 
 * @author Olaf
 * 
 */
public abstract class BaseServerTester extends TestCase {
    /**
     * Thread for stress testing
     * 
     * @author Olaf
     * 
     */
    private final class StressThread extends Thread {
	/**
	 * Create thread with name
	 * 
	 * @param name
	 *                Name of thread
	 */
	public StressThread(final String name) {
	    super(name);
	}

	/**
	 * Do some tests
	 * 
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public synchronized void run() {
	    while (!Thread.interrupted()) {
		// System.out.println("t" + j);
		testTranslations();
		counter++;
		// try {
		// synchronized (Thread.currentThread()) {
		// Thread.currentThread().wait(1);
		// }
		// } catch (final InterruptedException e) {
		// return;
		// }
	    }
	}

	/**
	 * @return how often resource bundles where erased
	 */
	public synchronized int getCounter() {
	    return counter;
	}

	/**
	 * Counts erase iterations.
	 */
	private int counter;
    }

    /**
     * Do test all translations here. This method is called by the stress test.
     */
    public abstract void testTranslations();

    /**
     * Thread that cleans up resources
     * 
     * @author Olaf
     * 
     */
    private final class CleanerThread extends Thread {

	/**
	 * Create thread with name
	 * 
	 * @param name
	 *                Name of thread
	 */
	public CleanerThread(final String name) {
	    super(name);
	}

	/**
	 * Erase cache periodically.
	 * 
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public synchronized void run() {

	    while (!Thread.interrupted()) {
		try {
		    Thread.currentThread().wait(1);
		} catch (final InterruptedException e) {
		    return;
		}
		// System.out.println("c");
		TestServer14TranslationManager.clean();
		counter++;
	    }
	}

	/**
	 * @return how often resource bundles where erased
	 */
	public synchronized int getCounter() {
	    return counter;
	}

	/**
	 * Counts erase iterations.
	 */
	private int counter;

    }

    /**
     * Create some threads for testing.
     */
    public void testStress() {
	final List<Thread> testThreads = new ArrayList<Thread>();
	final int testTime = 5000;
	final int threadCount = 100;

	// first: erase cache periodically
	testThreads.add(new CleanerThread("Cleaner Thread"));

	// create access threads
	for (int i = 0; i < threadCount; i++) {
	    final int j = i;
	    testThreads.add(new StressThread("Test Thread " + j));
	}

	// start all threads
	for (final Thread th : testThreads) {
	    th.start();
	}

	try {
	    synchronized (Thread.currentThread()) {
		Thread.currentThread().wait(testTime);
	    }
	} catch (final InterruptedException e) {
	    assertTrue("Master thread was interrupted: " + e.getMessage(),
		    false);
	}

	// stop all threads
	for (final Thread th : testThreads) {
	    th.interrupt();
	}

	// collect test counts
	int cleanerCounter = 0;
	int testCounter = 0;

	for (final Thread th : testThreads) {
	    if (th instanceof CleanerThread) {
		cleanerCounter = ((CleanerThread) th).getCounter();
	    } else {
		testCounter += ((StressThread) th).getCounter();
	    }
	}
	System.out.println(getClass().getSimpleName() + ": Cleans: "
		+ cleanerCounter + " Tests: " + testCounter
		+ " Tests per Clean:" + testCounter / cleanerCounter + " in "
		+ testTime + "ms with " + threadCount + " threads");
    }
}
