package de.olafpanz.translationtable.test;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.KeyStroke;

import junit.framework.TestCase;
import de.olafpanz.translationtable.test.client15.TestClient152Keys;
import de.olafpanz.translationtable.test.client15.TestClient152TranslationManager;

/**
 * Test content
 * 
 * @author Olaf
 * 
 */
public class ContentTest extends TestCase {

    /**
     * Do test accelerators
     */
    public void testAccelerators() {
	tstAcceleratorForLocale(new Locale("de"), KeyStroke.getKeyStroke(
		KeyEvent.VK_F4, InputEvent.ALT_MASK));
	tstAcceleratorForLocale(new Locale("en"), KeyStroke.getKeyStroke(
		KeyEvent.VK_X, InputEvent.CTRL_MASK));
	tstAcceleratorForLocale(new Locale("de", "CH"), KeyStroke.getKeyStroke(
		new Character('\u0104'), InputEvent.ALT_MASK));
	tstAcceleratorForLocale(new Locale("en", "US"), KeyStroke.getKeyStroke(
		KeyEvent.VK_F4, InputEvent.ALT_MASK | InputEvent.SHIFT_MASK));
    }

    /**
     * Do test mnemonic handling
     */
    public void testMnemonics() {

	tstMnemonicForLocale(new Locale("de"), '\u1234');
	tstMnemonicForLocale(new Locale("en"), 'x');
	tstMnemonicForLocale(new Locale("de", "CH"), '\u0123');
    }

    /**
     * Test accessing text content in different languages.
     */
    public void testTextContent() {

	tstTextForLocale(new Locale("de"), "\u00e4\u00f6\u00fc\u00df");
	tstTextForLocale(new Locale("en"),
		"\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2");
	tstTextForLocale(new Locale("de", "CH"),
		"\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3");

	tstTooltipForLocale(new Locale("de"), "\u00e4\u00f6\u00fc\u00df");
	tstTooltipForLocale(new Locale("en"),
		"\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2");
	tstTooltipForLocale(new Locale("de", "CH"),
		"\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3");
    }

    /**
     * Test TestClient152Keys.TX.MyGroup_k2 for a specified locale.
     * 
     * @param loc
     *                Locale to test for
     * @param expected
     *                The expected result string
     */
    private void tstAcceleratorForLocale(final Locale loc,
	    final KeyStroke expected) {
	Locale.setDefault(loc);
	final KeyStroke chr = TestClient152TranslationManager
		.get(TestClient152Keys.AC.MyGroup_k1);

	assertEquals(expected, chr);

    }

    /**
     * Test TestClient152Keys.TX.MyGroup_k2 for a specified locale.
     * 
     * @param loc
     *                Locale to test for
     * @param expected
     *                The expected result string
     */
    private void tstMnemonicForLocale(final Locale loc, final char expected) {
	Locale.setDefault(loc);
	final char chr = TestClient152TranslationManager
		.get(TestClient152Keys.MN.MyGroup_k1);

	assertEquals(expected, chr);

    }

    /**
     * Test TestClient152Keys.TX.MyGroup_k2 for a specified locale.
     * 
     * @param loc
     *                Locale to test for
     * @param expected
     *                The expected result string
     */
    private void tstTooltipForLocale(final Locale loc, final String expected) {
	Locale.setDefault(loc);
	final String txt = TestClient152TranslationManager
		.get(TestClient152Keys.TT.MyGroup_k2);
	assertEquals(expected, txt);

    }

    /**
     * Test TestClient152Keys.TX.MyGroup_k2 for a specified locale.
     * 
     * @param loc
     *                Locale to test for
     * @param expected
     *                The expected result string
     */
    private void tstTextForLocale(final Locale loc, final String expected) {
	Locale.setDefault(loc);
	final String txt = TestClient152TranslationManager
		.get(TestClient152Keys.TX.MyGroup_k2);
	assertEquals(expected, txt);

    }
}
