package de.olafpanz.translationtable.test;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.KeyStroke;

import junit.framework.TestCase;
import de.olafpanz.translationtable.test.client14.TestClient14Keys;
import de.olafpanz.translationtable.test.client14.TestClient14TranslationManager;

/**
 * Test tanslations
 * 
 * @author Olaf
 * 
 */
public class TestClient14Translations extends TestCase {

    /**
     * Test if mapping of locales works right.
     */
    public void testLocaleMapping() {

	Locale loc = TestClient14TranslationManager.mapLocale(Locale.GERMANY);
	assertEquals(new Locale("de"), loc);

	loc = TestClient14TranslationManager.mapLocale(new Locale("de", "CH"));
	assertEquals(new Locale("de", "CH"), loc);

	loc = TestClient14TranslationManager.mapLocale(Locale.GERMAN);
	assertEquals(new Locale("de"), loc);

	loc = TestClient14TranslationManager.mapLocale(new Locale("de", "AU"));
	assertEquals(new Locale("de"), loc);

	loc = TestClient14TranslationManager.mapLocale(new Locale("de", "AU",
		"XX"));
	assertEquals(new Locale("de"), loc);

	loc = TestClient14TranslationManager.mapLocale(Locale.CHINA);
	assertEquals(new Locale("de"), loc);

    }

    /**
     * Test translations of mode "client" and "jdk1.4"
     */
    public void testTranslations() {
	Locale.setDefault(Locale.GERMANY);
	assertEquals("Guten Morgen", TestClient14TranslationManager
		.getText(TestClient14Keys.TX_MyGroup_k1));

	Locale.setDefault(new Locale("de", "CH"));
	assertEquals("Gr\u00fczi", TestClient14TranslationManager
		.getText(TestClient14Keys.TX_MyGroup_k1));

	assertEquals("Die Daten werden \u00fcbernommen.",
		TestClient14TranslationManager
			.getTooltip(TestClient14Keys.TT_MyGroup_k1));
	final KeyStroke acc = TestClient14TranslationManager
		.getAccelerator(TestClient14Keys.AC_MyGroup_k1);
	assertEquals(KeyStroke
		.getKeyStroke(KeyEvent.VK_F4, InputEvent.ALT_MASK), acc);

	final Character ch = TestClient14TranslationManager
		.getMnemonic(TestClient14Keys.MN_MyGroup_k1);
	assertEquals(new Character('x'), ch);

	Locale.setDefault(Locale.CHINA);
	assertEquals("Guten Morgen", TestClient14TranslationManager
		.getText(TestClient14Keys.TX_MyGroup_k1));

    }
}
