package de.olafpanz.translationtable.test;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.KeyStroke;

import junit.framework.TestCase;
import de.olafpanz.translationtable.test.client15.TestClient151Keys;
import de.olafpanz.translationtable.test.client15.TestClient151TranslationManager;

/**
 * Test tanslations
 * 
 * @author Olaf
 * 
 */
public class TestClient15Translations extends TestCase {

    /**
     * Test if mapping of locales works right.
     */
    public void testLocaleMapping() {

	Locale loc = TestClient151TranslationManager.mapLocale(Locale.GERMANY);
	assertEquals(new Locale("de"), loc);

	loc = TestClient151TranslationManager.mapLocale(new Locale("de", "CH"));
	assertEquals(new Locale("de", "CH"), loc);

	loc = TestClient151TranslationManager.mapLocale(Locale.GERMAN);
	assertEquals(new Locale("de"), loc);

	loc = TestClient151TranslationManager.mapLocale(new Locale("de", "AU"));
	assertEquals(new Locale("de"), loc);

	loc = TestClient151TranslationManager.mapLocale(new Locale("de", "AU",
		"XX"));
	assertEquals(new Locale("de"), loc);

	loc = TestClient151TranslationManager.mapLocale(Locale.CHINA);
	assertEquals(new Locale("de"), loc);

    }

    /**
     * Test translations of mode "client" and "jdk1.4"
     */
    public void testTranslations() {
	Locale.setDefault(Locale.GERMANY);
	assertEquals("Guten Morgen", TestClient151TranslationManager
		.get(TestClient151Keys.TX.MyGroup_k1));

	Locale.setDefault(new Locale("de", "CH"));
	assertEquals("Gr\u00fczi", TestClient151TranslationManager
		.get(TestClient151Keys.TX.MyGroup_k1));

	assertEquals("Die Daten werden \u00fcbernommen.",
		TestClient151TranslationManager
			.get(TestClient151Keys.TT.MyGroup_k1));
	final KeyStroke acc = TestClient151TranslationManager
		.get(TestClient151Keys.AC.MyGroup_k1);
	assertEquals(KeyStroke
		.getKeyStroke(KeyEvent.VK_F4, InputEvent.ALT_MASK), acc);

	final Character ch = TestClient151TranslationManager
		.get(TestClient151Keys.MN.MyGroup_k1);

	assertEquals(new Character('x'), ch);

	Locale.setDefault(Locale.CHINA);
	assertEquals("Guten Morgen", TestClient151TranslationManager
		.get(TestClient151Keys.TX.MyGroup_k1));

    }
}
