package de.olafpanz.translationtable.test;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.KeyStroke;

import de.olafpanz.translationtable.test.server14.TestServer14Keys;
import de.olafpanz.translationtable.test.server14.TestServer14TranslationManager;

/**
 * Test tanslations
 * 
 * @author Olaf
 * 
 */
public class TestServer14Translations extends BaseServerTester {

    /**
     * Test if mapping of locales works right.
     */
    public void testLocaleMapping() {

	Locale loc = TestServer14TranslationManager.mapLocale(Locale.GERMANY);
	assertEquals(new Locale("de"), loc);

	loc = TestServer14TranslationManager.mapLocale(new Locale("de", "CH"));
	assertEquals(new Locale("de", "CH"), loc);

	loc = TestServer14TranslationManager.mapLocale(Locale.GERMAN);
	assertEquals(new Locale("de"), loc);

	loc = TestServer14TranslationManager.mapLocale(new Locale("de", "AU"));
	assertEquals(new Locale("de"), loc);

	loc = TestServer14TranslationManager.mapLocale(new Locale("de", "AU",
		"XX"));
	assertEquals(new Locale("de"), loc);

	loc = TestServer14TranslationManager.mapLocale(Locale.CHINA);
	assertEquals(new Locale("de"), loc);

    }

    /**
     * Test translations of mode "client" and "jdk1.4"
     */
    @Override
    public void testTranslations() {
	Locale.setDefault(Locale.ITALIAN);
	Locale locale = Locale.GERMANY;

	assertEquals("Guten Morgen", TestServer14TranslationManager.getText(
		TestServer14Keys.TX_MyGroup_k1, locale));

	locale = new Locale("de", "CH");
	assertEquals("Gr\u00fczi", TestServer14TranslationManager.getText(
		TestServer14Keys.TX_MyGroup_k1, locale));

	assertEquals("Die Daten werden \u00fcbernommen.",
		TestServer14TranslationManager.getTooltip(
			TestServer14Keys.TT_MyGroup_k1, locale));
	final KeyStroke acc = TestServer14TranslationManager.getAccelerator(
		TestServer14Keys.AC_MyGroup_k1, locale);
	assertEquals(KeyStroke
		.getKeyStroke(KeyEvent.VK_F4, InputEvent.ALT_MASK), acc);

	final Character ch = TestServer14TranslationManager.getMnemonic(
		TestServer14Keys.MN_MyGroup_k1, locale);
	assertEquals(new Character('x'), ch);

	locale = Locale.CHINA;
	assertEquals("Guten Morgen", TestServer14TranslationManager.getText(
		TestServer14Keys.TX_MyGroup_k1, locale));

    }

}
