package de.olafpanz.translationtable.test;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.KeyStroke;

import de.olafpanz.translationtable.test.server15.TestServer151Keys;
import de.olafpanz.translationtable.test.server15.TestServer151TranslationManager;

/**
 * Test tanslations
 * 
 * @author Olaf
 * 
 */
public class TestServer15Translations extends BaseServerTester {

    /**
     * Test if mapping of locales works right.
     */
    public void testLocaleMapping() {

	Locale loc = TestServer151TranslationManager.mapLocale(Locale.GERMANY);
	assertEquals(new Locale("de"), loc);

	loc = TestServer151TranslationManager.mapLocale(new Locale("de", "CH"));
	assertEquals(new Locale("de", "CH"), loc);

	loc = TestServer151TranslationManager.mapLocale(Locale.GERMAN);
	assertEquals(new Locale("de"), loc);

	loc = TestServer151TranslationManager.mapLocale(new Locale("de", "AU"));
	assertEquals(new Locale("de"), loc);

	loc = TestServer151TranslationManager.mapLocale(new Locale("de", "AU",
		"XX"));
	assertEquals(new Locale("de"), loc);

	loc = TestServer151TranslationManager.mapLocale(Locale.CHINA);
	assertEquals(new Locale("de"), loc);

    }

    /**
     * Test translations of mode "client" and "jdk1.4"
     */
    @Override
    public void testTranslations() {
	Locale.setDefault(Locale.ITALIAN);
	Locale locale = Locale.GERMANY;

	assertEquals("Guten Morgen", TestServer151TranslationManager.get(
		TestServer151Keys.TX.MyGroup_k1, locale));

	locale = new Locale("de", "CH");
	assertEquals("Gr\u00fczi", TestServer151TranslationManager.get(
		TestServer151Keys.TX.MyGroup_k1, locale));

	assertEquals("Die Daten werden \u00fcbernommen.",
		TestServer151TranslationManager.get(
			TestServer151Keys.TT.MyGroup_k1, locale));
	final KeyStroke acc = TestServer151TranslationManager.get(
		TestServer151Keys.AC.MyGroup_k1, locale);
	assertEquals(KeyStroke
		.getKeyStroke(KeyEvent.VK_F4, InputEvent.ALT_MASK), acc);

	final Character ch = TestServer151TranslationManager.get(
		TestServer151Keys.MN.MyGroup_k1, locale);
	assertEquals(new Character('x'), ch);

	locale = Locale.CHINA;
	assertEquals("Guten Morgen", TestServer151TranslationManager.get(
		TestServer151Keys.TX.MyGroup_k1, locale));

    }

}
