package de.olafpanz.translationtable.test.client15;

/**
 * Example Translation table
 * This interface defines all keys to translations.
 * Supported doc.getLocales(): Deutsch, Englisch, Deutsch (Schweiz)
 */
public interface TestClient151Keys
{
    /** Enumeration for Text */
    public enum TX {

        //***************************************************************
        //    Group: DefTest
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "x2"
         *     Englisch: "x2"
         *     Deutsch (Schweiz): "x2"
         */
        DefTest_def("TX_DefTest_def"),

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         */
        MyGroup_k1("TX_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private TX (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Tooltip */
    public enum TT {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         */
        MyGroup_k1("TT_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private TT (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Accelerator */
    public enum AC {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Alt+F4"
         *     Deutsch (Schweiz): "Alt+F4"
         */
        MyGroup_k1("AC_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private AC (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Mnemonic */
    public enum MN {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "a"
         *     Englisch: "b"
         *     Deutsch (Schweiz): "x"
         */
        MyGroup_k1("MN_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private MN (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }
}

