package de.olafpanz.translationtable.test.client15;

import javax.swing.KeyStroke;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Example Translation table
 * This manager manages access to translation table.
 */
public final class TestClient151TranslationManager
{

    /**
     * Array of Supported Locales. 
     */
    public static final Locale []SUPPORTED_LOCALES = new Locale[]{
        new Locale ("de"),
        new Locale ("en"),
        new Locale ("de","CH"),
    };

    /**
     * Maps from any locale to locale existing in translation table.
     @return Is never null.
     @param locale Null is not allowed here
     */
    public static final Locale mapLocale (final Locale locale){
        // (1) check for exact match
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) && loc.getVariant().equals (locale.getVariant())){
                return loc;
            }
        }
        // (2) check for matching language and country
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) ){
                return loc;
            }
        }
        // (3) check for matching language only
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage())){
                return loc;
            }
        }
        // (4) Use default language
        return SUPPORTED_LOCALES[0];
    }
    /**
     * The translation table
     */
     private static ResourceBundle bundle;

    /**
     * Last returned locale.
     */
     private static Locale currentLocale;

    /**
     * Clean all cached resources.
     */
    public static final void clean (){
        bundle = null;
        ResourceBundle.clearCache ();
    }

    /**
     * @return bundle for default locale.
     */
    private static final  ResourceBundle getBundle () {
        if (bundle==null || !Locale.getDefault().equals (currentLocale)){
            bundle = ResourceBundle.getBundle ("de.olafpanz.translationtable.test.client15.TestClient151",mapLocale(Locale.getDefault()));
        }
        return bundle;
    }

    /**
     * Return Text object.
     * @param key The key to requested resource. Null is not allowed.
     * @return Is never null.
     */
    public static final String get (final TestClient151Keys.TX key) {
        return (String)getBundle ().getObject (key.toString());
    }

    /**
     * Return Tooltip object.
     * @param key The key to requested resource. Null is not allowed.
     * @return Is never null.
     */
    public static final String get (final TestClient151Keys.TT key) {
        return (String)getBundle ().getObject (key.toString());
    }

    /**
     * Return Mnemonic object.
     * @param key The key to requested resource. Null is not allowed.
     * @return Is never null.
     */
    public static final Character get (final TestClient151Keys.MN key) {
        return (Character)getBundle ().getObject (key.toString());
    }

    /**
     * Return Accelerator object.
     * @param key The key to requested resource. Null is not allowed.
     * @return Is never null.
     */
    public static final KeyStroke get (final TestClient151Keys.AC key) {
        return (KeyStroke)getBundle ().getObject (key.toString());
    }

}
