package de.olafpanz.translationtable.test.client15;

/**
 * Second example translation table 
 * This interface defines all keys to translations.
 * Supported doc.getLocales(): Deutsch, Englisch, Deutsch (Schweiz), Englisch (Vereinigte Staaten von Amerika)
 */
public interface TestClient152Keys
{
    /** Enumeration for Text */
    public enum TX {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         *     Englisch (Vereinigte Staaten von Amerika): "Good morning"
         */
        MyGroup_k1("TX_MyGroup_k1"),

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "\u00e4\u00f6\u00fc\u00df"
         *     Englisch: "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         *     Deutsch (Schweiz): "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3"
         *     Englisch (Vereinigte Staaten von Amerika): "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         */
        MyGroup_k2("TX_MyGroup_k2");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private TX (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Tooltip */
    public enum TT {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         *     Englisch (Vereinigte Staaten von Amerika): "Close dialog and the values are accepted."
         */
        MyGroup_k1("TT_MyGroup_k1"),

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "\u00e4\u00f6\u00fc\u00df"
         *     Englisch: "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         *     Deutsch (Schweiz): "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3"
         *     Englisch (Vereinigte Staaten von Amerika): "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         */
        MyGroup_k2("TT_MyGroup_k2");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private TT (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Accelerator */
    public enum AC {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Ctrl+x"
         *     Deutsch (Schweiz): "Alt+\u0104"
         *     Englisch (Vereinigte Staaten von Amerika): "SHIFT+Alt+VK_F4"
         */
        MyGroup_k1("AC_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private AC (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }

    /** Enumeration for Mnemonic */
    public enum MN {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "\u1234"
         *     Englisch: "x"
         *     Deutsch (Schweiz): "\u0123"
         *     Englisch (Vereinigte Staaten von Amerika): "x"
         */
        MyGroup_k1("MN_MyGroup_k1");

        /** Key of enum object, used in the ResourceBundle as key. */
        private final String key;

        /**
         * Create new enum object with key.
         * @param key The key string used in the table.
         */
        private MN (final String key) {
            this.key = key;
        }

        /**
         * Return key of enum instance.
         * @return Is never null.
         */
        public String getKey () {
            return key;
        }

        /**
         * Returns the key of enum instance, of its name.
         * @returnIs never null. 
         */
        @Override public String toString () {
            return getKey();
        }

    }
}

