package de.olafpanz.translationtable.test.client15;

import java.awt.event.InputEvent;
import java.util.ListResourceBundle;
import javax.swing.KeyStroke;
    /**
     * Second example translation table 
     * Translations for Deutsch (Schweiz)
     */
public final class TestClient152_de_CH extends ListResourceBundle
{

    /**
     * Access method to get the translation table.
     * @return The translation table.
     */
    @Override
    public final Object[][] getContents()
    {
        return CONTENTS;
    }

    /**
     * The translation table.
     */
    private static final Object[][] CONTENTS =
    {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         *     Englisch (Vereinigte Staaten von Amerika): "Good morning"
         */
        { TestClient152Keys.TX.MyGroup_k1.getKey() , "Gr\u00fczi" },

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         *     Englisch (Vereinigte Staaten von Amerika): "Close dialog and the values are accepted."
         */
        { TestClient152Keys.TT.MyGroup_k1.getKey() , "Die Daten werden \u00fcbernommen." },

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Ctrl+x"
         *     Deutsch (Schweiz): "Alt+\u0104"
         *     Englisch (Vereinigte Staaten von Amerika): "SHIFT+Alt+VK_F4"
         */
        { TestClient152Keys.AC.MyGroup_k1.getKey() , KeyStroke.getKeyStroke (new Character ('\u0104'),InputEvent.ALT_MASK) },

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "\u1234"
         *     Englisch: "x"
         *     Deutsch (Schweiz): "\u0123"
         *     Englisch (Vereinigte Staaten von Amerika): "x"
         */
        { TestClient152Keys.MN.MyGroup_k1.getKey() , new Character ('\u0123') },

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "\u00e4\u00f6\u00fc\u00df"
         *     Englisch: "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         *     Deutsch (Schweiz): "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3"
         *     Englisch (Vereinigte Staaten von Amerika): "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         */
        { TestClient152Keys.TX.MyGroup_k2.getKey() , "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3" },

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "\u00e4\u00f6\u00fc\u00df"
         *     Englisch: "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         *     Deutsch (Schweiz): "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3"
         *     Englisch (Vereinigte Staaten von Amerika): "\u0418\u0448\u03f8\u03fc\u03fc\u03fe\u03e2"
         */
        { TestClient152Keys.TT.MyGroup_k2.getKey() , "\u05d1\u05e4\u05e0\u05dc\u05ea\u05e9\u05d3" },
    };

}
