package de.olafpanz.translationtable.test.server14;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ListResourceBundle;
import javax.swing.KeyStroke;
    /**
     * Example Translation table
     * Translations for Englisch
     */
public final class TestServer14_en extends ListResourceBundle
{

    /**
     * Access method to get the translation table.
     * @return The translation table.
     */
    public final Object[][] getContents()
    {
        return CONTENTS;
    }

    /**
     * The translation table.
     */
    private static final Object[][] CONTENTS =
    {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         */
        { TestServer14Keys.TX_MyGroup_k1 , "Good morning" },

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         */
        { TestServer14Keys.TT_MyGroup_k1 , "Close dialog and the values are accepted." },

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Alt+F4"
         *     Deutsch (Schweiz): "Alt+F4"
         */
        { TestServer14Keys.AC_MyGroup_k1 , KeyStroke.getKeyStroke (KeyEvent.VK_F4,InputEvent.ALT_MASK) },

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "a"
         *     Englisch: "B"
         *     Deutsch (Schweiz): "x"
         */
        { TestServer14Keys.MN_MyGroup_k1 , new Character ('B') },
    };

}
