package de.olafpanz.translationtable.test.server15;

import javax.swing.KeyStroke;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Map;
import java.util.HashMap;

/**
 * Example Translation table
 * This manager manages access to translation table.
 */
public final class TestServer151TranslationManager
{

    /**
     * Array of Supported Locales. 
     */
    public static final Locale []SUPPORTED_LOCALES = new Locale[]{
        new Locale ("de"),
        new Locale ("en"),
        new Locale ("de","CH"),
    };

    /**
     * Maps from any locale to locale existing in translation table.
     @return Is never null.
     @param locale Null is not allowed here
     */
    public static final Locale mapLocale (final Locale locale){
        // (1) check for exact match
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) && loc.getVariant().equals (locale.getVariant())){
                return loc;
            }
        }
        // (2) check for matching language and country
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage()) && loc.getCountry().equals (locale.getCountry()) ){
                return loc;
            }
        }
        // (3) check for matching language only
        for (Locale loc : SUPPORTED_LOCALES) {
            if (loc.getLanguage().equals (locale.getLanguage())){
                return loc;
            }
        }
        // (4) Use default language
        return SUPPORTED_LOCALES[0];
    }
    /**
     * Maps from locale to translation table
     */
    private final static Map<Locale,ResourceBundle> bundleMap = new HashMap<Locale,ResourceBundle>();

    /**
     * Clean all cached resources.
     */
    public static final void clean (){
        synchronized (TestServer151TranslationManager.class){
            bundleMap.clear();
            ResourceBundle.clearCache ();
        }
    }

    /**
     * @param locale Locale of requested bundle.
     * @return bundle for default locale.
     */
    private static final  ResourceBundle getBundle (final Locale locale) {
        ResourceBundle bundle = null;
        synchronized (TestServer151TranslationManager.class){
            bundle = bundleMap.get (locale);
            if (bundle == null){
                bundle = ResourceBundle.getBundle ("de.olafpanz.translationtable.test.server15.TestServer151",mapLocale(locale));
                bundleMap.put (locale,bundle);
            }
        }
        return bundle;
    }

    /**
     * Return Text object.
     * @param key The key to requested resource. Null is not allowed.
     * @param locale Locale in that the resource is requested.
     * @return Is never null.
     */
    public static final String get (final TestServer151Keys.TX key,final Locale locale) {
        return (String)getBundle (locale).getObject (key.toString());
    }

    /**
     * Return Tooltip object.
     * @param key The key to requested resource. Null is not allowed.
     * @param locale Locale in that the resource is requested.
     * @return Is never null.
     */
    public static final String get (final TestServer151Keys.TT key,final Locale locale) {
        return (String)getBundle (locale).getObject (key.toString());
    }

    /**
     * Return Mnemonic object.
     * @param key The key to requested resource. Null is not allowed.
     * @param locale Locale in that the resource is requested.
     * @return Is never null.
     */
    public static final Character get (final TestServer151Keys.MN key,final Locale locale) {
        return (Character)getBundle (locale).getObject (key.toString());
    }

    /**
     * Return Accelerator object.
     * @param key The key to requested resource. Null is not allowed.
     * @param locale Locale in that the resource is requested.
     * @return Is never null.
     */
    public static final KeyStroke get (final TestServer151Keys.AC key,final Locale locale) {
        return (KeyStroke)getBundle (locale).getObject (key.toString());
    }

}
