package de.olafpanz.translationtable.test.server15;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ListResourceBundle;
import javax.swing.KeyStroke;
    /**
     * Example Translation table
     * Translations for Deutsch (Schweiz)
     */
public final class TestServer151_de_CH extends ListResourceBundle
{

    /**
     * Access method to get the translation table.
     * @return The translation table.
     */
    @Override
    public final Object[][] getContents()
    {
        return CONTENTS;
    }

    /**
     * The translation table.
     */
    private static final Object[][] CONTENTS =
    {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         */
        { TestServer151Keys.TX.MyGroup_k1.getKey() , "Gr\u00fczi" },

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         */
        { TestServer151Keys.TT.MyGroup_k1.getKey() , "Die Daten werden \u00fcbernommen." },

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Alt+F4"
         *     Deutsch (Schweiz): "Alt+F4"
         */
        { TestServer151Keys.AC.MyGroup_k1.getKey() , KeyStroke.getKeyStroke (KeyEvent.VK_F4,InputEvent.ALT_MASK) },

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "a"
         *     Englisch: "b"
         *     Deutsch (Schweiz): "x"
         */
        { TestServer151Keys.MN.MyGroup_k1.getKey() , new Character ('x') },
    };

}
