package de.olafpanz.translationtable.test.server15;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ListResourceBundle;
import javax.swing.KeyStroke;
    /**
     * Second example translation table 
     * Translations for Deutsch
     */
public final class TestServer152_de extends ListResourceBundle
{

    /**
     * Access method to get the translation table.
     * @return The translation table.
     */
    @Override
    public final Object[][] getContents()
    {
        return CONTENTS;
    }

    /**
     * The translation table.
     */
    private static final Object[][] CONTENTS =
    {

        //***************************************************************
        //    Group: MyGroup
        //***************************************************************

        /**
         *  null (Text)
         *  Translations:
         *     Deutsch: "Guten Morgen"
         *     Englisch: "Good morning"
         *     Deutsch (Schweiz): "Gr\u00fczi"
         */
        { TestServer152Keys.TX.MyGroup_k1.getKey() , "Guten Morgen" },

        /**
         *  null (Tooltip)
         *  Translations:
         *     Deutsch: "Die Daten werden \u00fcbernommen."
         *     Englisch: "Close dialog and the values are accepted."
         *     Deutsch (Schweiz): "Die Daten werden \u00fcbernommen."
         */
        { TestServer152Keys.TT.MyGroup_k1.getKey() , "Die Daten werden \u00fcbernommen." },

        /**
         *  null (Accelerator)
         *  Translations:
         *     Deutsch: "Alt+F4"
         *     Englisch: "Alt+F4"
         *     Deutsch (Schweiz): "Alt+F4"
         */
        { TestServer152Keys.AC.MyGroup_k1.getKey() , KeyStroke.getKeyStroke (KeyEvent.VK_F4,InputEvent.ALT_MASK) },

        /**
         *  null (Mnemonic)
         *  Translations:
         *     Deutsch: "a"
         *     Englisch: "b"
         *     Deutsch (Schweiz): "\u0123"
         */
        { TestServer152Keys.MN.MyGroup_k1.getKey() , new Character ('a') },
    };

}
